package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSecretRotationPolicy invokes the kms.UpdateSecretRotationPolicy API synchronously
func (client *Client) UpdateSecretRotationPolicy(request *UpdateSecretRotationPolicyRequest) (response *UpdateSecretRotationPolicyResponse, err error) {
	response = CreateUpdateSecretRotationPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSecretRotationPolicyWithChan invokes the kms.UpdateSecretRotationPolicy API asynchronously
func (client *Client) UpdateSecretRotationPolicyWithChan(request *UpdateSecretRotationPolicyRequest) (<-chan *UpdateSecretRotationPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateSecretRotationPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSecretRotationPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSecretRotationPolicyWithCallback invokes the kms.UpdateSecretRotationPolicy API asynchronously
func (client *Client) UpdateSecretRotationPolicyWithCallback(request *UpdateSecretRotationPolicyRequest, callback func(response *UpdateSecretRotationPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSecretRotationPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateSecretRotationPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSecretRotationPolicyRequest is the request struct for api UpdateSecretRotationPolicy
type UpdateSecretRotationPolicyRequest struct {
	*requests.RpcRequest
	RotationInterval        string           `position:"Query" name:"RotationInterval"`
	EnableAutomaticRotation requests.Boolean `position:"Query" name:"EnableAutomaticRotation"`
	SecretName              string           `position:"Query" name:"SecretName"`
}

// UpdateSecretRotationPolicyResponse is the response struct for api UpdateSecretRotationPolicy
type UpdateSecretRotationPolicyResponse struct {
	*responses.BaseResponse
	SecretName string `json:"SecretName" xml:"SecretName"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateSecretRotationPolicyRequest creates a request to invoke UpdateSecretRotationPolicy API
func CreateUpdateSecretRotationPolicyRequest() (request *UpdateSecretRotationPolicyRequest) {
	request = &UpdateSecretRotationPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "UpdateSecretRotationPolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSecretRotationPolicyResponse creates a response to parse from UpdateSecretRotationPolicy response
func CreateUpdateSecretRotationPolicyResponse() (response *UpdateSecretRotationPolicyResponse) {
	response = &UpdateSecretRotationPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
