package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransformClientId invokes the iot.TransformClientId API synchronously
func (client *Client) TransformClientId(request *TransformClientIdRequest) (response *TransformClientIdResponse, err error) {
	response = CreateTransformClientIdResponse()
	err = client.DoAction(request, response)
	return
}

// TransformClientIdWithChan invokes the iot.TransformClientId API asynchronously
func (client *Client) TransformClientIdWithChan(request *TransformClientIdRequest) (<-chan *TransformClientIdResponse, <-chan error) {
	responseChan := make(chan *TransformClientIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransformClientId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransformClientIdWithCallback invokes the iot.TransformClientId API asynchronously
func (client *Client) TransformClientIdWithCallback(request *TransformClientIdRequest, callback func(response *TransformClientIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransformClientIdResponse
		var err error
		defer close(result)
		response, err = client.TransformClientId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransformClientIdRequest is the request struct for api TransformClientId
type TransformClientIdRequest struct {
	*requests.RpcRequest
	AuthConfig    string `position:"Query" name:"AuthConfig"`
	ClientId      string `position:"Query" name:"ClientId"`
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// TransformClientIdResponse is the response struct for api TransformClientId
type TransformClientIdResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateTransformClientIdRequest creates a request to invoke TransformClientId API
func CreateTransformClientIdRequest() (request *TransformClientIdRequest) {
	request = &TransformClientIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "TransformClientId", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTransformClientIdResponse creates a response to parse from TransformClientId response
func CreateTransformClientIdResponse() (response *TransformClientIdResponse) {
	response = &TransformClientIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
