package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySceneRule invokes the iot.QuerySceneRule API synchronously
func (client *Client) QuerySceneRule(request *QuerySceneRuleRequest) (response *QuerySceneRuleResponse, err error) {
	response = CreateQuerySceneRuleResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySceneRuleWithChan invokes the iot.QuerySceneRule API asynchronously
func (client *Client) QuerySceneRuleWithChan(request *QuerySceneRuleRequest) (<-chan *QuerySceneRuleResponse, <-chan error) {
	responseChan := make(chan *QuerySceneRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySceneRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySceneRuleWithCallback invokes the iot.QuerySceneRule API asynchronously
func (client *Client) QuerySceneRuleWithCallback(request *QuerySceneRuleRequest, callback func(response *QuerySceneRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySceneRuleResponse
		var err error
		defer close(result)
		response, err = client.QuerySceneRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySceneRuleRequest is the request struct for api QuerySceneRule
type QuerySceneRuleRequest struct {
	*requests.RpcRequest
	RuleName      string           `position:"Query" name:"RuleName"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QuerySceneRuleResponse is the response struct for api QuerySceneRule
type QuerySceneRuleResponse struct {
	*responses.BaseResponse
	RequestId    string               `json:"RequestId" xml:"RequestId"`
	Success      bool                 `json:"Success" xml:"Success"`
	Code         string               `json:"Code" xml:"Code"`
	ErrorMessage string               `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySceneRule `json:"Data" xml:"Data"`
}

// CreateQuerySceneRuleRequest creates a request to invoke QuerySceneRule API
func CreateQuerySceneRuleRequest() (request *QuerySceneRuleRequest) {
	request = &QuerySceneRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySceneRule", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySceneRuleResponse creates a response to parse from QuerySceneRule response
func CreateQuerySceneRuleResponse() (response *QuerySceneRuleResponse) {
	response = &QuerySceneRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
