package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDeviceTunnelStatus invokes the iot.GetDeviceTunnelStatus API synchronously
func (client *Client) GetDeviceTunnelStatus(request *GetDeviceTunnelStatusRequest) (response *GetDeviceTunnelStatusResponse, err error) {
	response = CreateGetDeviceTunnelStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetDeviceTunnelStatusWithChan invokes the iot.GetDeviceTunnelStatus API asynchronously
func (client *Client) GetDeviceTunnelStatusWithChan(request *GetDeviceTunnelStatusRequest) (<-chan *GetDeviceTunnelStatusResponse, <-chan error) {
	responseChan := make(chan *GetDeviceTunnelStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDeviceTunnelStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDeviceTunnelStatusWithCallback invokes the iot.GetDeviceTunnelStatus API asynchronously
func (client *Client) GetDeviceTunnelStatusWithCallback(request *GetDeviceTunnelStatusRequest, callback func(response *GetDeviceTunnelStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDeviceTunnelStatusResponse
		var err error
		defer close(result)
		response, err = client.GetDeviceTunnelStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDeviceTunnelStatusRequest is the request struct for api GetDeviceTunnelStatus
type GetDeviceTunnelStatusRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// GetDeviceTunnelStatusResponse is the response struct for api GetDeviceTunnelStatus
type GetDeviceTunnelStatusResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateGetDeviceTunnelStatusRequest creates a request to invoke GetDeviceTunnelStatus API
func CreateGetDeviceTunnelStatusRequest() (request *GetDeviceTunnelStatusRequest) {
	request = &GetDeviceTunnelStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetDeviceTunnelStatus", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDeviceTunnelStatusResponse creates a response to parse from GetDeviceTunnelStatus response
func CreateGetDeviceTunnelStatusResponse() (response *GetDeviceTunnelStatusResponse) {
	response = &GetDeviceTunnelStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
