package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSAMLProvider invokes the ims.GetSAMLProvider API synchronously
func (client *Client) GetSAMLProvider(request *GetSAMLProviderRequest) (response *GetSAMLProviderResponse, err error) {
	response = CreateGetSAMLProviderResponse()
	err = client.DoAction(request, response)
	return
}

// GetSAMLProviderWithChan invokes the ims.GetSAMLProvider API asynchronously
func (client *Client) GetSAMLProviderWithChan(request *GetSAMLProviderRequest) (<-chan *GetSAMLProviderResponse, <-chan error) {
	responseChan := make(chan *GetSAMLProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSAMLProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSAMLProviderWithCallback invokes the ims.GetSAMLProvider API asynchronously
func (client *Client) GetSAMLProviderWithCallback(request *GetSAMLProviderRequest, callback func(response *GetSAMLProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSAMLProviderResponse
		var err error
		defer close(result)
		response, err = client.GetSAMLProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSAMLProviderRequest is the request struct for api GetSAMLProvider
type GetSAMLProviderRequest struct {
	*requests.RpcRequest
	AkProxySuffix    string `position:"Query" name:"AkProxySuffix"`
	SAMLProviderName string `position:"Query" name:"SAMLProviderName"`
}

// GetSAMLProviderResponse is the response struct for api GetSAMLProvider
type GetSAMLProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	SAMLProvider SAMLProvider `json:"SAMLProvider" xml:"SAMLProvider"`
}

// CreateGetSAMLProviderRequest creates a request to invoke GetSAMLProvider API
func CreateGetSAMLProviderRequest() (request *GetSAMLProviderRequest) {
	request = &GetSAMLProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GetSAMLProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSAMLProviderResponse creates a response to parse from GetSAMLProvider response
func CreateGetSAMLProviderResponse() (response *GetSAMLProviderResponse) {
	response = &GetSAMLProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
