package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImageBlindCharacterWatermark invokes the imageenhan.ImageBlindCharacterWatermark API synchronously
func (client *Client) ImageBlindCharacterWatermark(request *ImageBlindCharacterWatermarkRequest) (response *ImageBlindCharacterWatermarkResponse, err error) {
	response = CreateImageBlindCharacterWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// ImageBlindCharacterWatermarkWithChan invokes the imageenhan.ImageBlindCharacterWatermark API asynchronously
func (client *Client) ImageBlindCharacterWatermarkWithChan(request *ImageBlindCharacterWatermarkRequest) (<-chan *ImageBlindCharacterWatermarkResponse, <-chan error) {
	responseChan := make(chan *ImageBlindCharacterWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImageBlindCharacterWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImageBlindCharacterWatermarkWithCallback invokes the imageenhan.ImageBlindCharacterWatermark API asynchronously
func (client *Client) ImageBlindCharacterWatermarkWithCallback(request *ImageBlindCharacterWatermarkRequest, callback func(response *ImageBlindCharacterWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImageBlindCharacterWatermarkResponse
		var err error
		defer close(result)
		response, err = client.ImageBlindCharacterWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImageBlindCharacterWatermarkRequest is the request struct for api ImageBlindCharacterWatermark
type ImageBlindCharacterWatermarkRequest struct {
	*requests.RpcRequest
	WatermarkImageURL string           `position:"Body" name:"WatermarkImageURL"`
	OutputFileType    string           `position:"Body" name:"OutputFileType"`
	Text              string           `position:"Body" name:"Text"`
	QualityFactor     requests.Integer `position:"Body" name:"QualityFactor"`
	FunctionType      string           `position:"Body" name:"FunctionType"`
	OriginImageURL    string           `position:"Body" name:"OriginImageURL"`
}

// ImageBlindCharacterWatermarkResponse is the response struct for api ImageBlindCharacterWatermark
type ImageBlindCharacterWatermarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateImageBlindCharacterWatermarkRequest creates a request to invoke ImageBlindCharacterWatermark API
func CreateImageBlindCharacterWatermarkRequest() (request *ImageBlindCharacterWatermarkRequest) {
	request = &ImageBlindCharacterWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "ImageBlindCharacterWatermark", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImageBlindCharacterWatermarkResponse creates a response to parse from ImageBlindCharacterWatermark response
func CreateImageBlindCharacterWatermarkResponse() (response *ImageBlindCharacterWatermarkResponse) {
	response = &ImageBlindCharacterWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
