package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssessComposition invokes the imageenhan.AssessComposition API synchronously
func (client *Client) AssessComposition(request *AssessCompositionRequest) (response *AssessCompositionResponse, err error) {
	response = CreateAssessCompositionResponse()
	err = client.DoAction(request, response)
	return
}

// AssessCompositionWithChan invokes the imageenhan.AssessComposition API asynchronously
func (client *Client) AssessCompositionWithChan(request *AssessCompositionRequest) (<-chan *AssessCompositionResponse, <-chan error) {
	responseChan := make(chan *AssessCompositionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssessComposition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssessCompositionWithCallback invokes the imageenhan.AssessComposition API asynchronously
func (client *Client) AssessCompositionWithCallback(request *AssessCompositionRequest, callback func(response *AssessCompositionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssessCompositionResponse
		var err error
		defer close(result)
		response, err = client.AssessComposition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssessCompositionRequest is the request struct for api AssessComposition
type AssessCompositionRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// AssessCompositionResponse is the response struct for api AssessComposition
type AssessCompositionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAssessCompositionRequest creates a request to invoke AssessComposition API
func CreateAssessCompositionRequest() (request *AssessCompositionRequest) {
	request = &AssessCompositionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "AssessComposition", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssessCompositionResponse creates a response to parse from AssessComposition response
func CreateAssessCompositionResponse() (response *AssessCompositionResponse) {
	response = &AssessCompositionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
