package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEngineDefaultAuth invokes the hitsdb.GetEngineDefaultAuth API synchronously
func (client *Client) GetEngineDefaultAuth(request *GetEngineDefaultAuthRequest) (response *GetEngineDefaultAuthResponse, err error) {
	response = CreateGetEngineDefaultAuthResponse()
	err = client.DoAction(request, response)
	return
}

// GetEngineDefaultAuthWithChan invokes the hitsdb.GetEngineDefaultAuth API asynchronously
func (client *Client) GetEngineDefaultAuthWithChan(request *GetEngineDefaultAuthRequest) (<-chan *GetEngineDefaultAuthResponse, <-chan error) {
	responseChan := make(chan *GetEngineDefaultAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEngineDefaultAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEngineDefaultAuthWithCallback invokes the hitsdb.GetEngineDefaultAuth API asynchronously
func (client *Client) GetEngineDefaultAuthWithCallback(request *GetEngineDefaultAuthRequest, callback func(response *GetEngineDefaultAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEngineDefaultAuthResponse
		var err error
		defer close(result)
		response, err = client.GetEngineDefaultAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEngineDefaultAuthRequest is the request struct for api GetEngineDefaultAuth
type GetEngineDefaultAuthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// GetEngineDefaultAuthResponse is the response struct for api GetEngineDefaultAuth
type GetEngineDefaultAuthResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	InstanceId string     `json:"InstanceId" xml:"InstanceId"`
	AuthInfos  []AuthInfo `json:"AuthInfos" xml:"AuthInfos"`
}

// CreateGetEngineDefaultAuthRequest creates a request to invoke GetEngineDefaultAuth API
func CreateGetEngineDefaultAuthRequest() (request *GetEngineDefaultAuthRequest) {
	request = &GetEngineDefaultAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "GetEngineDefaultAuth", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEngineDefaultAuthResponse creates a response to parse from GetEngineDefaultAuth response
func CreateGetEngineDefaultAuthResponse() (response *GetEngineDefaultAuthResponse) {
	response = &GetEngineDefaultAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
