package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResizeMultiZoneClusterNodeCount invokes the hbase.ResizeMultiZoneClusterNodeCount API synchronously
func (client *Client) ResizeMultiZoneClusterNodeCount(request *ResizeMultiZoneClusterNodeCountRequest) (response *ResizeMultiZoneClusterNodeCountResponse, err error) {
	response = CreateResizeMultiZoneClusterNodeCountResponse()
	err = client.DoAction(request, response)
	return
}

// ResizeMultiZoneClusterNodeCountWithChan invokes the hbase.ResizeMultiZoneClusterNodeCount API asynchronously
func (client *Client) ResizeMultiZoneClusterNodeCountWithChan(request *ResizeMultiZoneClusterNodeCountRequest) (<-chan *ResizeMultiZoneClusterNodeCountResponse, <-chan error) {
	responseChan := make(chan *ResizeMultiZoneClusterNodeCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResizeMultiZoneClusterNodeCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResizeMultiZoneClusterNodeCountWithCallback invokes the hbase.ResizeMultiZoneClusterNodeCount API asynchronously
func (client *Client) ResizeMultiZoneClusterNodeCountWithCallback(request *ResizeMultiZoneClusterNodeCountRequest, callback func(response *ResizeMultiZoneClusterNodeCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResizeMultiZoneClusterNodeCountResponse
		var err error
		defer close(result)
		response, err = client.ResizeMultiZoneClusterNodeCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResizeMultiZoneClusterNodeCountRequest is the request struct for api ResizeMultiZoneClusterNodeCount
type ResizeMultiZoneClusterNodeCountRequest struct {
	*requests.RpcRequest
	PrimaryVSwitchId     string           `position:"Query" name:"PrimaryVSwitchId"`
	StandbyVSwitchId     string           `position:"Query" name:"StandbyVSwitchId"`
	LogNodeCount         requests.Integer `position:"Query" name:"LogNodeCount"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	PrimaryCoreNodeCount requests.Integer `position:"Query" name:"PrimaryCoreNodeCount"`
	CoreNodeCount        requests.Integer `position:"Query" name:"CoreNodeCount"`
	StandbyCoreNodeCount requests.Integer `position:"Query" name:"StandbyCoreNodeCount"`
	ArbiterVSwitchId     string           `position:"Query" name:"ArbiterVSwitchId"`
}

// ResizeMultiZoneClusterNodeCountResponse is the response struct for api ResizeMultiZoneClusterNodeCount
type ResizeMultiZoneClusterNodeCountResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResizeMultiZoneClusterNodeCountRequest creates a request to invoke ResizeMultiZoneClusterNodeCount API
func CreateResizeMultiZoneClusterNodeCountRequest() (request *ResizeMultiZoneClusterNodeCountRequest) {
	request = &ResizeMultiZoneClusterNodeCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ResizeMultiZoneClusterNodeCount", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResizeMultiZoneClusterNodeCountResponse creates a response to parse from ResizeMultiZoneClusterNodeCount response
func CreateResizeMultiZoneClusterNodeCountResponse() (response *ResizeMultiZoneClusterNodeCountResponse) {
	response = &ResizeMultiZoneClusterNodeCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
