package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskWarningLine invokes the hbase.DescribeDiskWarningLine API synchronously
func (client *Client) DescribeDiskWarningLine(request *DescribeDiskWarningLineRequest) (response *DescribeDiskWarningLineResponse, err error) {
	response = CreateDescribeDiskWarningLineResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskWarningLineWithChan invokes the hbase.DescribeDiskWarningLine API asynchronously
func (client *Client) DescribeDiskWarningLineWithChan(request *DescribeDiskWarningLineRequest) (<-chan *DescribeDiskWarningLineResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskWarningLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskWarningLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskWarningLineWithCallback invokes the hbase.DescribeDiskWarningLine API asynchronously
func (client *Client) DescribeDiskWarningLineWithCallback(request *DescribeDiskWarningLineRequest, callback func(response *DescribeDiskWarningLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskWarningLineResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskWarningLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskWarningLineRequest is the request struct for api DescribeDiskWarningLine
type DescribeDiskWarningLineRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeDiskWarningLineResponse is the response struct for api DescribeDiskWarningLine
type DescribeDiskWarningLineResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	WarningLine string `json:"WarningLine" xml:"WarningLine"`
}

// CreateDescribeDiskWarningLineRequest creates a request to invoke DescribeDiskWarningLine API
func CreateDescribeDiskWarningLineRequest() (request *DescribeDiskWarningLineRequest) {
	request = &DescribeDiskWarningLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeDiskWarningLine", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskWarningLineResponse creates a response to parse from DescribeDiskWarningLine response
func CreateDescribeDiskWarningLineResponse() (response *DescribeDiskWarningLineResponse) {
	response = &DescribeDiskWarningLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
