package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataShareInstances invokes the gpdb.DescribeDataShareInstances API synchronously
func (client *Client) DescribeDataShareInstances(request *DescribeDataShareInstancesRequest) (response *DescribeDataShareInstancesResponse, err error) {
	response = CreateDescribeDataShareInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataShareInstancesWithChan invokes the gpdb.DescribeDataShareInstances API asynchronously
func (client *Client) DescribeDataShareInstancesWithChan(request *DescribeDataShareInstancesRequest) (<-chan *DescribeDataShareInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeDataShareInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataShareInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataShareInstancesWithCallback invokes the gpdb.DescribeDataShareInstances API asynchronously
func (client *Client) DescribeDataShareInstancesWithCallback(request *DescribeDataShareInstancesRequest, callback func(response *DescribeDataShareInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataShareInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataShareInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataShareInstancesRequest is the request struct for api DescribeDataShareInstances
type DescribeDataShareInstancesRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	SearchValue     string           `position:"Query" name:"SearchValue"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDataShareInstancesResponse is the response struct for api DescribeDataShareInstances
type DescribeDataShareInstancesResponse struct {
	*responses.BaseResponse
	TotalRecordCount int                               `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageRecordCount  int                               `json:"PageRecordCount" xml:"PageRecordCount"`
	RequestId        string                            `json:"RequestId" xml:"RequestId"`
	PageNumber       int                               `json:"PageNumber" xml:"PageNumber"`
	Items            ItemsInDescribeDataShareInstances `json:"Items" xml:"Items"`
}

// CreateDescribeDataShareInstancesRequest creates a request to invoke DescribeDataShareInstances API
func CreateDescribeDataShareInstancesRequest() (request *DescribeDataShareInstancesRequest) {
	request = &DescribeDataShareInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDataShareInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDataShareInstancesResponse creates a response to parse from DescribeDataShareInstances response
func CreateDescribeDataShareInstancesResponse() (response *DescribeDataShareInstancesResponse) {
	response = &DescribeDataShareInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
