package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataBackups invokes the gpdb.DescribeDataBackups API synchronously
func (client *Client) DescribeDataBackups(request *DescribeDataBackupsRequest) (response *DescribeDataBackupsResponse, err error) {
	response = CreateDescribeDataBackupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataBackupsWithChan invokes the gpdb.DescribeDataBackups API asynchronously
func (client *Client) DescribeDataBackupsWithChan(request *DescribeDataBackupsRequest) (<-chan *DescribeDataBackupsResponse, <-chan error) {
	responseChan := make(chan *DescribeDataBackupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataBackups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataBackupsWithCallback invokes the gpdb.DescribeDataBackups API asynchronously
func (client *Client) DescribeDataBackupsWithCallback(request *DescribeDataBackupsRequest, callback func(response *DescribeDataBackupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataBackupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataBackups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataBackupsRequest is the request struct for api DescribeDataBackups
type DescribeDataBackupsRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	DataType     string           `position:"Query" name:"DataType"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	BackupId     string           `position:"Query" name:"BackupId"`
	EndTime      string           `position:"Query" name:"EndTime"`
	BackupStatus string           `position:"Query" name:"BackupStatus"`
	BackupMode   string           `position:"Query" name:"BackupMode"`
}

// DescribeDataBackupsResponse is the response struct for api DescribeDataBackups
type DescribeDataBackupsResponse struct {
	*responses.BaseResponse
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	Items      []Backup `json:"Items" xml:"Items"`
}

// CreateDescribeDataBackupsRequest creates a request to invoke DescribeDataBackups API
func CreateDescribeDataBackupsRequest() (request *DescribeDataBackupsRequest) {
	request = &DescribeDataBackupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDataBackups", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDataBackupsResponse creates a response to parse from DescribeDataBackups response
func CreateDescribeDataBackupsResponse() (response *DescribeDataBackupsResponse) {
	response = &DescribeDataBackupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
