package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAccelerator invokes the ga.UpdateAccelerator API synchronously
func (client *Client) UpdateAccelerator(request *UpdateAcceleratorRequest) (response *UpdateAcceleratorResponse, err error) {
	response = CreateUpdateAcceleratorResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAcceleratorWithChan invokes the ga.UpdateAccelerator API asynchronously
func (client *Client) UpdateAcceleratorWithChan(request *UpdateAcceleratorRequest) (<-chan *UpdateAcceleratorResponse, <-chan error) {
	responseChan := make(chan *UpdateAcceleratorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAccelerator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAcceleratorWithCallback invokes the ga.UpdateAccelerator API asynchronously
func (client *Client) UpdateAcceleratorWithCallback(request *UpdateAcceleratorRequest, callback func(response *UpdateAcceleratorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAcceleratorResponse
		var err error
		defer close(result)
		response, err = client.UpdateAccelerator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAcceleratorRequest is the request struct for api UpdateAccelerator
type UpdateAcceleratorRequest struct {
	*requests.RpcRequest
	AutoPay           requests.Boolean `position:"Query" name:"AutoPay"`
	PromotionOptionNo string           `position:"Query" name:"PromotionOptionNo"`
	ClientToken       string           `position:"Query" name:"ClientToken"`
	Description       string           `position:"Query" name:"Description"`
	AutoUseCoupon     requests.Boolean `position:"Query" name:"AutoUseCoupon"`
	Spec              string           `position:"Query" name:"Spec"`
	Name              string           `position:"Query" name:"Name"`
	AcceleratorId     string           `position:"Query" name:"AcceleratorId"`
}

// UpdateAcceleratorResponse is the response struct for api UpdateAccelerator
type UpdateAcceleratorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAcceleratorRequest creates a request to invoke UpdateAccelerator API
func CreateUpdateAcceleratorRequest() (request *UpdateAcceleratorRequest) {
	request = &UpdateAcceleratorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "UpdateAccelerator", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAcceleratorResponse creates a response to parse from UpdateAccelerator response
func CreateUpdateAcceleratorResponse() (response *UpdateAcceleratorResponse) {
	response = &UpdateAcceleratorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
