package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectInfraredLivingFace invokes the facebody.DetectInfraredLivingFace API synchronously
func (client *Client) DetectInfraredLivingFace(request *DetectInfraredLivingFaceRequest) (response *DetectInfraredLivingFaceResponse, err error) {
	response = CreateDetectInfraredLivingFaceResponse()
	err = client.DoAction(request, response)
	return
}

// DetectInfraredLivingFaceWithChan invokes the facebody.DetectInfraredLivingFace API asynchronously
func (client *Client) DetectInfraredLivingFaceWithChan(request *DetectInfraredLivingFaceRequest) (<-chan *DetectInfraredLivingFaceResponse, <-chan error) {
	responseChan := make(chan *DetectInfraredLivingFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectInfraredLivingFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectInfraredLivingFaceWithCallback invokes the facebody.DetectInfraredLivingFace API asynchronously
func (client *Client) DetectInfraredLivingFaceWithCallback(request *DetectInfraredLivingFaceRequest, callback func(response *DetectInfraredLivingFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectInfraredLivingFaceResponse
		var err error
		defer close(result)
		response, err = client.DetectInfraredLivingFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectInfraredLivingFaceRequest is the request struct for api DetectInfraredLivingFace
type DetectInfraredLivingFaceRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean                 `position:"Query" name:"FormatResultToJson"`
	OssFile            string                           `position:"Query" name:"OssFile"`
	Tasks              *[]DetectInfraredLivingFaceTasks `position:"Body" name:"Tasks"  type:"Repeated"`
	RequestProxyBy     string                           `position:"Query" name:"RequestProxyBy"`
}

// DetectInfraredLivingFaceTasks is a repeated param struct in DetectInfraredLivingFaceRequest
type DetectInfraredLivingFaceTasks struct {
	ImageURL string `name:"ImageURL"`
}

// DetectInfraredLivingFaceResponse is the response struct for api DetectInfraredLivingFace
type DetectInfraredLivingFaceResponse struct {
	*responses.BaseResponse
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Code      string                         `json:"Code" xml:"Code"`
	Message   string                         `json:"Message" xml:"Message"`
	Data      DataInDetectInfraredLivingFace `json:"Data" xml:"Data"`
}

// CreateDetectInfraredLivingFaceRequest creates a request to invoke DetectInfraredLivingFace API
func CreateDetectInfraredLivingFaceRequest() (request *DetectInfraredLivingFaceRequest) {
	request = &DetectInfraredLivingFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DetectInfraredLivingFace", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectInfraredLivingFaceResponse creates a response to parse from DetectInfraredLivingFace response
func CreateDetectInfraredLivingFaceResponse() (response *DetectInfraredLivingFaceResponse) {
	response = &DetectInfraredLivingFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
