package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServerLoadBalancerListenMonitor invokes the ens.DescribeServerLoadBalancerListenMonitor API synchronously
func (client *Client) DescribeServerLoadBalancerListenMonitor(request *DescribeServerLoadBalancerListenMonitorRequest) (response *DescribeServerLoadBalancerListenMonitorResponse, err error) {
	response = CreateDescribeServerLoadBalancerListenMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServerLoadBalancerListenMonitorWithChan invokes the ens.DescribeServerLoadBalancerListenMonitor API asynchronously
func (client *Client) DescribeServerLoadBalancerListenMonitorWithChan(request *DescribeServerLoadBalancerListenMonitorRequest) (<-chan *DescribeServerLoadBalancerListenMonitorResponse, <-chan error) {
	responseChan := make(chan *DescribeServerLoadBalancerListenMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServerLoadBalancerListenMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServerLoadBalancerListenMonitorWithCallback invokes the ens.DescribeServerLoadBalancerListenMonitor API asynchronously
func (client *Client) DescribeServerLoadBalancerListenMonitorWithCallback(request *DescribeServerLoadBalancerListenMonitorRequest, callback func(response *DescribeServerLoadBalancerListenMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServerLoadBalancerListenMonitorResponse
		var err error
		defer close(result)
		response, err = client.DescribeServerLoadBalancerListenMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServerLoadBalancerListenMonitorRequest is the request struct for api DescribeServerLoadBalancerListenMonitor
type DescribeServerLoadBalancerListenMonitorRequest struct {
	*requests.RpcRequest
	StartTime      string `position:"Query" name:"StartTime"`
	LoadBalancerId string `position:"Query" name:"LoadBalancerId"`
	Proto          string `position:"Query" name:"Proto"`
	VPort          string `position:"Query" name:"VPort"`
	EndTime        string `position:"Query" name:"EndTime"`
}

// DescribeServerLoadBalancerListenMonitorResponse is the response struct for api DescribeServerLoadBalancerListenMonitor
type DescribeServerLoadBalancerListenMonitorResponse struct {
	*responses.BaseResponse
	RequestId                     string            `json:"RequestId" xml:"RequestId"`
	ServerLoadBalancerMonitorData []EslbMonitorList `json:"ServerLoadBalancerMonitorData" xml:"ServerLoadBalancerMonitorData"`
}

// CreateDescribeServerLoadBalancerListenMonitorRequest creates a request to invoke DescribeServerLoadBalancerListenMonitor API
func CreateDescribeServerLoadBalancerListenMonitorRequest() (request *DescribeServerLoadBalancerListenMonitorRequest) {
	request = &DescribeServerLoadBalancerListenMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeServerLoadBalancerListenMonitor", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeServerLoadBalancerListenMonitorResponse creates a response to parse from DescribeServerLoadBalancerListenMonitor response
func CreateDescribeServerLoadBalancerListenMonitorResponse() (response *DescribeServerLoadBalancerListenMonitorResponse) {
	response = &DescribeServerLoadBalancerListenMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
