package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNCInformation invokes the ens.DescribeNCInformation API synchronously
func (client *Client) DescribeNCInformation(request *DescribeNCInformationRequest) (response *DescribeNCInformationResponse, err error) {
	response = CreateDescribeNCInformationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNCInformationWithChan invokes the ens.DescribeNCInformation API asynchronously
func (client *Client) DescribeNCInformationWithChan(request *DescribeNCInformationRequest) (<-chan *DescribeNCInformationResponse, <-chan error) {
	responseChan := make(chan *DescribeNCInformationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNCInformation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNCInformationWithCallback invokes the ens.DescribeNCInformation API asynchronously
func (client *Client) DescribeNCInformationWithCallback(request *DescribeNCInformationRequest, callback func(response *DescribeNCInformationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNCInformationResponse
		var err error
		defer close(result)
		response, err = client.DescribeNCInformation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNCInformationRequest is the request struct for api DescribeNCInformation
type DescribeNCInformationRequest struct {
	*requests.RpcRequest
	EnsRegionId  string `position:"Query" name:"EnsRegionId"`
	ResourceId   string `position:"Query" name:"ResourceId"`
	OpenapiCheck string `position:"Query" name:"OpenapiCheck"`
}

// DescribeNCInformationResponse is the response struct for api DescribeNCInformation
type DescribeNCInformationResponse struct {
	*responses.BaseResponse
	CurrentPage int        `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int        `json:"TotalCount" xml:"TotalCount"`
	Msg         string     `json:"Msg" xml:"Msg"`
	Desc        string     `json:"Desc" xml:"Desc"`
	RequestId   string     `json:"RequestId" xml:"RequestId"`
	Pager       Pager      `json:"Pager" xml:"Pager"`
	Data        []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeNCInformationRequest creates a request to invoke DescribeNCInformation API
func CreateDescribeNCInformationRequest() (request *DescribeNCInformationRequest) {
	request = &DescribeNCInformationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeNCInformation", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeNCInformationResponse creates a response to parse from DescribeNCInformation response
func CreateDescribeNCInformationResponse() (response *DescribeNCInformationResponse) {
	response = &DescribeNCInformationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
