package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AccosicateNetworkAcl invokes the ens.AccosicateNetworkAcl API synchronously
func (client *Client) AccosicateNetworkAcl(request *AccosicateNetworkAclRequest) (response *AccosicateNetworkAclResponse, err error) {
	response = CreateAccosicateNetworkAclResponse()
	err = client.DoAction(request, response)
	return
}

// AccosicateNetworkAclWithChan invokes the ens.AccosicateNetworkAcl API asynchronously
func (client *Client) AccosicateNetworkAclWithChan(request *AccosicateNetworkAclRequest) (<-chan *AccosicateNetworkAclResponse, <-chan error) {
	responseChan := make(chan *AccosicateNetworkAclResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AccosicateNetworkAcl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AccosicateNetworkAclWithCallback invokes the ens.AccosicateNetworkAcl API asynchronously
func (client *Client) AccosicateNetworkAclWithCallback(request *AccosicateNetworkAclRequest, callback func(response *AccosicateNetworkAclResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AccosicateNetworkAclResponse
		var err error
		defer close(result)
		response, err = client.AccosicateNetworkAcl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AccosicateNetworkAclRequest is the request struct for api AccosicateNetworkAcl
type AccosicateNetworkAclRequest struct {
	*requests.RpcRequest
	NetworkAclId string                          `position:"Query" name:"NetworkAclId"`
	Resource     *[]AccosicateNetworkAclResource `position:"Query" name:"Resource"  type:"Repeated"`
}

// AccosicateNetworkAclResource is a repeated param struct in AccosicateNetworkAclRequest
type AccosicateNetworkAclResource struct {
	ResourceId   string `name:"ResourceId"`
	ResourceType string `name:"ResourceType"`
}

// AccosicateNetworkAclResponse is the response struct for api AccosicateNetworkAcl
type AccosicateNetworkAclResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAccosicateNetworkAclRequest creates a request to invoke AccosicateNetworkAcl API
func CreateAccosicateNetworkAclRequest() (request *AccosicateNetworkAclRequest) {
	request = &AccosicateNetworkAclRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "AccosicateNetworkAcl", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAccosicateNetworkAclResponse creates a response to parse from AccosicateNetworkAcl response
func CreateAccosicateNetworkAclResponse() (response *AccosicateNetworkAclResponse) {
	response = &AccosicateNetworkAclResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
