package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFlowProjectUser invokes the emr.CreateFlowProjectUser API synchronously
func (client *Client) CreateFlowProjectUser(request *CreateFlowProjectUserRequest) (response *CreateFlowProjectUserResponse, err error) {
	response = CreateCreateFlowProjectUserResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFlowProjectUserWithChan invokes the emr.CreateFlowProjectUser API asynchronously
func (client *Client) CreateFlowProjectUserWithChan(request *CreateFlowProjectUserRequest) (<-chan *CreateFlowProjectUserResponse, <-chan error) {
	responseChan := make(chan *CreateFlowProjectUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFlowProjectUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFlowProjectUserWithCallback invokes the emr.CreateFlowProjectUser API asynchronously
func (client *Client) CreateFlowProjectUserWithCallback(request *CreateFlowProjectUserRequest, callback func(response *CreateFlowProjectUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFlowProjectUserResponse
		var err error
		defer close(result)
		response, err = client.CreateFlowProjectUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFlowProjectUserRequest is the request struct for api CreateFlowProjectUser
type CreateFlowProjectUserRequest struct {
	*requests.RpcRequest
	ProjectId string                       `position:"Query" name:"ProjectId"`
	User      *[]CreateFlowProjectUserUser `position:"Query" name:"User"  type:"Repeated"`
}

// CreateFlowProjectUserUser is a repeated param struct in CreateFlowProjectUserRequest
type CreateFlowProjectUserUser struct {
	UserId   string `name:"UserId"`
	UserName string `name:"UserName"`
}

// CreateFlowProjectUserResponse is the response struct for api CreateFlowProjectUser
type CreateFlowProjectUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCreateFlowProjectUserRequest creates a request to invoke CreateFlowProjectUser API
func CreateCreateFlowProjectUserRequest() (request *CreateFlowProjectUserRequest) {
	request = &CreateFlowProjectUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateFlowProjectUser", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFlowProjectUserResponse creates a response to parse from CreateFlowProjectUser response
func CreateCreateFlowProjectUserResponse() (response *CreateFlowProjectUserResponse) {
	response = &CreateFlowProjectUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
