package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryLaunchTimeDistribution invokes the emas_appmonitor.QueryLaunchTimeDistribution API synchronously
func (client *Client) QueryLaunchTimeDistribution(request *QueryLaunchTimeDistributionRequest) (response *QueryLaunchTimeDistributionResponse, err error) {
	response = CreateQueryLaunchTimeDistributionResponse()
	err = client.DoAction(request, response)
	return
}

// QueryLaunchTimeDistributionWithChan invokes the emas_appmonitor.QueryLaunchTimeDistribution API asynchronously
func (client *Client) QueryLaunchTimeDistributionWithChan(request *QueryLaunchTimeDistributionRequest) (<-chan *QueryLaunchTimeDistributionResponse, <-chan error) {
	responseChan := make(chan *QueryLaunchTimeDistributionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryLaunchTimeDistribution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryLaunchTimeDistributionWithCallback invokes the emas_appmonitor.QueryLaunchTimeDistribution API asynchronously
func (client *Client) QueryLaunchTimeDistributionWithCallback(request *QueryLaunchTimeDistributionRequest, callback func(response *QueryLaunchTimeDistributionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryLaunchTimeDistributionResponse
		var err error
		defer close(result)
		response, err = client.QueryLaunchTimeDistribution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryLaunchTimeDistributionRequest is the request struct for api QueryLaunchTimeDistribution
type QueryLaunchTimeDistributionRequest struct {
	*requests.RpcRequest
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	LaunchType         string           `position:"Body" name:"LaunchType"`
	DeviceLevel        string           `position:"Body" name:"DeviceLevel"`
	Province           *[]string        `position:"Body" name:"Province"  type:"Repeated"`
	StatType           string           `position:"Body" name:"StatType"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
}

// QueryLaunchTimeDistributionResponse is the response struct for api QueryLaunchTimeDistribution
type QueryLaunchTimeDistributionResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQueryLaunchTimeDistributionRequest creates a request to invoke QueryLaunchTimeDistribution API
func CreateQueryLaunchTimeDistributionRequest() (request *QueryLaunchTimeDistributionRequest) {
	request = &QueryLaunchTimeDistributionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QueryLaunchTimeDistribution", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryLaunchTimeDistributionResponse creates a response to parse from QueryLaunchTimeDistribution response
func CreateQueryLaunchTimeDistributionResponse() (response *QueryLaunchTimeDistributionResponse) {
	response = &QueryLaunchTimeDistributionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
