package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSnapshotSetting invokes the elasticsearch.DescribeSnapshotSetting API synchronously
func (client *Client) DescribeSnapshotSetting(request *DescribeSnapshotSettingRequest) (response *DescribeSnapshotSettingResponse, err error) {
	response = CreateDescribeSnapshotSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSnapshotSettingWithChan invokes the elasticsearch.DescribeSnapshotSetting API asynchronously
func (client *Client) DescribeSnapshotSettingWithChan(request *DescribeSnapshotSettingRequest) (<-chan *DescribeSnapshotSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeSnapshotSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSnapshotSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSnapshotSettingWithCallback invokes the elasticsearch.DescribeSnapshotSetting API asynchronously
func (client *Client) DescribeSnapshotSettingWithCallback(request *DescribeSnapshotSettingRequest, callback func(response *DescribeSnapshotSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSnapshotSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeSnapshotSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSnapshotSettingRequest is the request struct for api DescribeSnapshotSetting
type DescribeSnapshotSettingRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeSnapshotSettingResponse is the response struct for api DescribeSnapshotSetting
type DescribeSnapshotSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeSnapshotSettingRequest creates a request to invoke DescribeSnapshotSetting API
func CreateDescribeSnapshotSettingRequest() (request *DescribeSnapshotSettingRequest) {
	request = &DescribeSnapshotSettingRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeSnapshotSetting", "/openapi/instances/[InstanceId]/snapshot-setting", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeSnapshotSettingResponse creates a response to parse from DescribeSnapshotSetting response
func CreateDescribeSnapshotSettingResponse() (response *DescribeSnapshotSettingResponse) {
	response = &DescribeSnapshotSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
