package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetSnapshot invokes the ecd.ResetSnapshot API synchronously
func (client *Client) ResetSnapshot(request *ResetSnapshotRequest) (response *ResetSnapshotResponse, err error) {
	response = CreateResetSnapshotResponse()
	err = client.DoAction(request, response)
	return
}

// ResetSnapshotWithChan invokes the ecd.ResetSnapshot API asynchronously
func (client *Client) ResetSnapshotWithChan(request *ResetSnapshotRequest) (<-chan *ResetSnapshotResponse, <-chan error) {
	responseChan := make(chan *ResetSnapshotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetSnapshot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetSnapshotWithCallback invokes the ecd.ResetSnapshot API asynchronously
func (client *Client) ResetSnapshotWithCallback(request *ResetSnapshotRequest, callback func(response *ResetSnapshotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetSnapshotResponse
		var err error
		defer close(result)
		response, err = client.ResetSnapshot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetSnapshotRequest is the request struct for api ResetSnapshot
type ResetSnapshotRequest struct {
	*requests.RpcRequest
	SnapshotId string `position:"Query" name:"SnapshotId"`
}

// ResetSnapshotResponse is the response struct for api ResetSnapshot
type ResetSnapshotResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetSnapshotRequest creates a request to invoke ResetSnapshot API
func CreateResetSnapshotRequest() (request *ResetSnapshotRequest) {
	request = &ResetSnapshotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ResetSnapshot", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetSnapshotResponse creates a response to parse from ResetSnapshot response
func CreateResetSnapshotResponse() (response *ResetSnapshotResponse) {
	response = &ResetSnapshotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
