package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyCoordinatePrivilege invokes the ecd.ApplyCoordinatePrivilege API synchronously
func (client *Client) ApplyCoordinatePrivilege(request *ApplyCoordinatePrivilegeRequest) (response *ApplyCoordinatePrivilegeResponse, err error) {
	response = CreateApplyCoordinatePrivilegeResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyCoordinatePrivilegeWithChan invokes the ecd.ApplyCoordinatePrivilege API asynchronously
func (client *Client) ApplyCoordinatePrivilegeWithChan(request *ApplyCoordinatePrivilegeRequest) (<-chan *ApplyCoordinatePrivilegeResponse, <-chan error) {
	responseChan := make(chan *ApplyCoordinatePrivilegeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyCoordinatePrivilege(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyCoordinatePrivilegeWithCallback invokes the ecd.ApplyCoordinatePrivilege API asynchronously
func (client *Client) ApplyCoordinatePrivilegeWithCallback(request *ApplyCoordinatePrivilegeRequest, callback func(response *ApplyCoordinatePrivilegeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyCoordinatePrivilegeResponse
		var err error
		defer close(result)
		response, err = client.ApplyCoordinatePrivilege(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyCoordinatePrivilegeRequest is the request struct for api ApplyCoordinatePrivilege
type ApplyCoordinatePrivilegeRequest struct {
	*requests.RpcRequest
	CoId      string `position:"Query" name:"CoId"`
	UserType  string `position:"Query" name:"UserType"`
	Uuid      string `position:"Query" name:"Uuid"`
	EndUserId string `position:"Query" name:"EndUserId"`
}

// ApplyCoordinatePrivilegeResponse is the response struct for api ApplyCoordinatePrivilege
type ApplyCoordinatePrivilegeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateApplyCoordinatePrivilegeRequest creates a request to invoke ApplyCoordinatePrivilege API
func CreateApplyCoordinatePrivilegeRequest() (request *ApplyCoordinatePrivilegeRequest) {
	request = &ApplyCoordinatePrivilegeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ApplyCoordinatePrivilege", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyCoordinatePrivilegeResponse creates a response to parse from ApplyCoordinatePrivilege response
func CreateApplyCoordinatePrivilegeResponse() (response *ApplyCoordinatePrivilegeResponse) {
	response = &ApplyCoordinatePrivilegeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
