package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceDLink invokes the eas.DeleteResourceDLink API synchronously
func (client *Client) DeleteResourceDLink(request *DeleteResourceDLinkRequest) (response *DeleteResourceDLinkResponse, err error) {
	response = CreateDeleteResourceDLinkResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceDLinkWithChan invokes the eas.DeleteResourceDLink API asynchronously
func (client *Client) DeleteResourceDLinkWithChan(request *DeleteResourceDLinkRequest) (<-chan *DeleteResourceDLinkResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceDLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceDLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceDLinkWithCallback invokes the eas.DeleteResourceDLink API asynchronously
func (client *Client) DeleteResourceDLinkWithCallback(request *DeleteResourceDLinkRequest, callback func(response *DeleteResourceDLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceDLinkResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceDLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceDLinkRequest is the request struct for api DeleteResourceDLink
type DeleteResourceDLinkRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	ClusterId  string `position:"Path" name:"ClusterId"`
}

// DeleteResourceDLinkResponse is the response struct for api DeleteResourceDLink
type DeleteResourceDLinkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteResourceDLinkRequest creates a request to invoke DeleteResourceDLink API
func CreateDeleteResourceDLinkRequest() (request *DeleteResourceDLinkRequest) {
	request = &DeleteResourceDLinkRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DeleteResourceDLink", "/api/v2/resources/[ClusterId]/[ResourceId]/dlink", "eas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteResourceDLinkResponse creates a response to parse from DeleteResourceDLink response
func CreateDeleteResourceDLinkResponse() (response *DeleteResourceDLinkResponse) {
	response = &DeleteResourceDLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
