package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteDataExport invokes the dms_enterprise.ExecuteDataExport API synchronously
// api document: https://help.aliyun.com/api/dms-enterprise/executedataexport.html
func (client *Client) ExecuteDataExport(request *ExecuteDataExportRequest) (response *ExecuteDataExportResponse, err error) {
	response = CreateExecuteDataExportResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteDataExportWithChan invokes the dms_enterprise.ExecuteDataExport API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/executedataexport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecuteDataExportWithChan(request *ExecuteDataExportRequest) (<-chan *ExecuteDataExportResponse, <-chan error) {
	responseChan := make(chan *ExecuteDataExportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteDataExport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteDataExportWithCallback invokes the dms_enterprise.ExecuteDataExport API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/executedataexport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecuteDataExportWithCallback(request *ExecuteDataExportRequest, callback func(response *ExecuteDataExportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteDataExportResponse
		var err error
		defer close(result)
		response, err = client.ExecuteDataExport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteDataExportRequest is the request struct for api ExecuteDataExport
type ExecuteDataExportRequest struct {
	*requests.RpcRequest
	ActionDetail map[string]interface{} `position:"Query" name:"ActionDetail"`
	OrderId      requests.Integer       `position:"Query" name:"OrderId"`
	ActionName   string                 `position:"Query" name:"ActionName"`
	Tid          requests.Integer       `position:"Query" name:"Tid"`
}

// ExecuteDataExportResponse is the response struct for api ExecuteDataExport
type ExecuteDataExportResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateExecuteDataExportRequest creates a request to invoke ExecuteDataExport API
func CreateExecuteDataExportRequest() (request *ExecuteDataExportRequest) {
	request = &ExecuteDataExportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ExecuteDataExport", "dmsenterprise", "openAPI")
	return
}

// CreateExecuteDataExportResponse creates a response to parse from ExecuteDataExport response
func CreateExecuteDataExportResponse() (response *ExecuteDataExportResponse) {
	response = &ExecuteDataExportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
