package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PauseDataExportJob invokes the dms_enterprise.PauseDataExportJob API synchronously
func (client *Client) PauseDataExportJob(request *PauseDataExportJobRequest) (response *PauseDataExportJobResponse, err error) {
	response = CreatePauseDataExportJobResponse()
	err = client.DoAction(request, response)
	return
}

// PauseDataExportJobWithChan invokes the dms_enterprise.PauseDataExportJob API asynchronously
func (client *Client) PauseDataExportJobWithChan(request *PauseDataExportJobRequest) (<-chan *PauseDataExportJobResponse, <-chan error) {
	responseChan := make(chan *PauseDataExportJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PauseDataExportJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PauseDataExportJobWithCallback invokes the dms_enterprise.PauseDataExportJob API asynchronously
func (client *Client) PauseDataExportJobWithCallback(request *PauseDataExportJobRequest, callback func(response *PauseDataExportJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PauseDataExportJobResponse
		var err error
		defer close(result)
		response, err = client.PauseDataExportJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PauseDataExportJobRequest is the request struct for api PauseDataExportJob
type PauseDataExportJobRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	JobId   requests.Integer `position:"Query" name:"JobId"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// PauseDataExportJobResponse is the response struct for api PauseDataExportJob
type PauseDataExportJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreatePauseDataExportJobRequest creates a request to invoke PauseDataExportJob API
func CreatePauseDataExportJobRequest() (request *PauseDataExportJobRequest) {
	request = &PauseDataExportJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "PauseDataExportJob", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePauseDataExportJobResponse creates a response to parse from PauseDataExportJob response
func CreatePauseDataExportJobResponse() (response *PauseDataExportJobResponse) {
	response = &PauseDataExportJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
