package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthorizedUsersForDatabase invokes the dms_enterprise.ListAuthorizedUsersForDatabase API synchronously
func (client *Client) ListAuthorizedUsersForDatabase(request *ListAuthorizedUsersForDatabaseRequest) (response *ListAuthorizedUsersForDatabaseResponse, err error) {
	response = CreateListAuthorizedUsersForDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthorizedUsersForDatabaseWithChan invokes the dms_enterprise.ListAuthorizedUsersForDatabase API asynchronously
func (client *Client) ListAuthorizedUsersForDatabaseWithChan(request *ListAuthorizedUsersForDatabaseRequest) (<-chan *ListAuthorizedUsersForDatabaseResponse, <-chan error) {
	responseChan := make(chan *ListAuthorizedUsersForDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthorizedUsersForDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthorizedUsersForDatabaseWithCallback invokes the dms_enterprise.ListAuthorizedUsersForDatabase API asynchronously
func (client *Client) ListAuthorizedUsersForDatabaseWithCallback(request *ListAuthorizedUsersForDatabaseRequest, callback func(response *ListAuthorizedUsersForDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthorizedUsersForDatabaseResponse
		var err error
		defer close(result)
		response, err = client.ListAuthorizedUsersForDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthorizedUsersForDatabaseRequest is the request struct for api ListAuthorizedUsersForDatabase
type ListAuthorizedUsersForDatabaseRequest struct {
	*requests.RpcRequest
	SearchKey  string           `position:"Query" name:"SearchKey"`
	PageNumber string           `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageSize   string           `position:"Query" name:"PageSize"`
	DbId       string           `position:"Query" name:"DbId"`
	Logic      requests.Boolean `position:"Query" name:"Logic"`
}

// ListAuthorizedUsersForDatabaseResponse is the response struct for api ListAuthorizedUsersForDatabase
type ListAuthorizedUsersForDatabaseResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Users     []UsersItem `json:"Users" xml:"Users"`
}

// CreateListAuthorizedUsersForDatabaseRequest creates a request to invoke ListAuthorizedUsersForDatabase API
func CreateListAuthorizedUsersForDatabaseRequest() (request *ListAuthorizedUsersForDatabaseRequest) {
	request = &ListAuthorizedUsersForDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListAuthorizedUsersForDatabase", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAuthorizedUsersForDatabaseResponse creates a response to parse from ListAuthorizedUsersForDatabase response
func CreateListAuthorizedUsersForDatabaseResponse() (response *ListAuthorizedUsersForDatabaseResponse) {
	response = &ListAuthorizedUsersForDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
