package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStandardGroup invokes the dms_enterprise.GetStandardGroup API synchronously
func (client *Client) GetStandardGroup(request *GetStandardGroupRequest) (response *GetStandardGroupResponse, err error) {
	response = CreateGetStandardGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetStandardGroupWithChan invokes the dms_enterprise.GetStandardGroup API asynchronously
func (client *Client) GetStandardGroupWithChan(request *GetStandardGroupRequest) (<-chan *GetStandardGroupResponse, <-chan error) {
	responseChan := make(chan *GetStandardGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStandardGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStandardGroupWithCallback invokes the dms_enterprise.GetStandardGroup API asynchronously
func (client *Client) GetStandardGroupWithCallback(request *GetStandardGroupRequest, callback func(response *GetStandardGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStandardGroupResponse
		var err error
		defer close(result)
		response, err = client.GetStandardGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStandardGroupRequest is the request struct for api GetStandardGroup
type GetStandardGroupRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	GroupId requests.Integer `position:"Query" name:"GroupId"`
}

// GetStandardGroupResponse is the response struct for api GetStandardGroup
type GetStandardGroupResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Success       bool          `json:"Success" xml:"Success"`
	ErrorMessage  string        `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode     string        `json:"ErrorCode" xml:"ErrorCode"`
	StandardGroup StandardGroup `json:"StandardGroup" xml:"StandardGroup"`
}

// CreateGetStandardGroupRequest creates a request to invoke GetStandardGroup API
func CreateGetStandardGroupRequest() (request *GetStandardGroupRequest) {
	request = &GetStandardGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetStandardGroup", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetStandardGroupResponse creates a response to parse from GetStandardGroup response
func CreateGetStandardGroupResponse() (response *GetStandardGroupResponse) {
	response = &GetStandardGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
