package dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDatabaseAccessPoint invokes the dg.CreateDatabaseAccessPoint API synchronously
func (client *Client) CreateDatabaseAccessPoint(request *CreateDatabaseAccessPointRequest) (response *CreateDatabaseAccessPointResponse, err error) {
	response = CreateCreateDatabaseAccessPointResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDatabaseAccessPointWithChan invokes the dg.CreateDatabaseAccessPoint API asynchronously
func (client *Client) CreateDatabaseAccessPointWithChan(request *CreateDatabaseAccessPointRequest) (<-chan *CreateDatabaseAccessPointResponse, <-chan error) {
	responseChan := make(chan *CreateDatabaseAccessPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDatabaseAccessPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDatabaseAccessPointWithCallback invokes the dg.CreateDatabaseAccessPoint API asynchronously
func (client *Client) CreateDatabaseAccessPointWithCallback(request *CreateDatabaseAccessPointRequest, callback func(response *CreateDatabaseAccessPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDatabaseAccessPointResponse
		var err error
		defer close(result)
		response, err = client.CreateDatabaseAccessPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDatabaseAccessPointRequest is the request struct for api CreateDatabaseAccessPoint
type CreateDatabaseAccessPointRequest struct {
	*requests.RpcRequest
	VpcAZone     string `position:"Body" name:"VpcAZone"`
	ClientToken  string `position:"Body" name:"ClientToken"`
	DbInstanceId string `position:"Body" name:"DbInstanceId"`
	VpcRegionId  string `position:"Body" name:"VpcRegionId"`
	VSwitchId    string `position:"Body" name:"VSwitchId"`
	VpcId        string `position:"Body" name:"VpcId"`
}

// CreateDatabaseAccessPointResponse is the response struct for api CreateDatabaseAccessPoint
type CreateDatabaseAccessPointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateDatabaseAccessPointRequest creates a request to invoke CreateDatabaseAccessPoint API
func CreateCreateDatabaseAccessPointRequest() (request *CreateDatabaseAccessPointRequest) {
	request = &CreateDatabaseAccessPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dg", "2019-03-27", "CreateDatabaseAccessPoint", "dg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDatabaseAccessPointResponse creates a response to parse from CreateDatabaseAccessPoint response
func CreateCreateDatabaseAccessPointResponse() (response *CreateDatabaseAccessPointResponse) {
	response = &CreateDatabaseAccessPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
