package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceDiskType invokes the dds.ModifyDBInstanceDiskType API synchronously
func (client *Client) ModifyDBInstanceDiskType(request *ModifyDBInstanceDiskTypeRequest) (response *ModifyDBInstanceDiskTypeResponse, err error) {
	response = CreateModifyDBInstanceDiskTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceDiskTypeWithChan invokes the dds.ModifyDBInstanceDiskType API asynchronously
func (client *Client) ModifyDBInstanceDiskTypeWithChan(request *ModifyDBInstanceDiskTypeRequest) (<-chan *ModifyDBInstanceDiskTypeResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceDiskTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceDiskType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceDiskTypeWithCallback invokes the dds.ModifyDBInstanceDiskType API asynchronously
func (client *Client) ModifyDBInstanceDiskTypeWithCallback(request *ModifyDBInstanceDiskTypeRequest, callback func(response *ModifyDBInstanceDiskTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceDiskTypeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceDiskType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceDiskTypeRequest is the request struct for api ModifyDBInstanceDiskType
type ModifyDBInstanceDiskTypeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtraParam            string           `position:"Query" name:"ExtraParam"`
	CouponNo              string           `position:"Query" name:"CouponNo"`
	DBInstanceId          string           `position:"Query" name:"DBInstanceId"`
	DbInstanceStorageType string           `position:"Query" name:"DbInstanceStorageType"`
	BusinessInfo          string           `position:"Query" name:"BusinessInfo"`
	AutoPay               requests.Boolean `position:"Query" name:"AutoPay"`
	ProvisionedIops       requests.Integer `position:"Query" name:"ProvisionedIops"`
	AutoRenew             string           `position:"Query" name:"AutoRenew"`
	OrderType             string           `position:"Query" name:"OrderType"`
}

// ModifyDBInstanceDiskTypeResponse is the response struct for api ModifyDBInstanceDiskType
type ModifyDBInstanceDiskTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateModifyDBInstanceDiskTypeRequest creates a request to invoke ModifyDBInstanceDiskType API
func CreateModifyDBInstanceDiskTypeRequest() (request *ModifyDBInstanceDiskTypeRequest) {
	request = &ModifyDBInstanceDiskTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "ModifyDBInstanceDiskType", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceDiskTypeResponse creates a response to parse from ModifyDBInstanceDiskType response
func CreateModifyDBInstanceDiskTypeResponse() (response *ModifyDBInstanceDiskTypeResponse) {
	response = &ModifyDBInstanceDiskTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
