package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTagResources invokes the ddoscoo.DeleteTagResources API synchronously
func (client *Client) DeleteTagResources(request *DeleteTagResourcesRequest) (response *DeleteTagResourcesResponse, err error) {
	response = CreateDeleteTagResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTagResourcesWithChan invokes the ddoscoo.DeleteTagResources API asynchronously
func (client *Client) DeleteTagResourcesWithChan(request *DeleteTagResourcesRequest) (<-chan *DeleteTagResourcesResponse, <-chan error) {
	responseChan := make(chan *DeleteTagResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTagResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTagResourcesWithCallback invokes the ddoscoo.DeleteTagResources API asynchronously
func (client *Client) DeleteTagResourcesWithCallback(request *DeleteTagResourcesRequest, callback func(response *DeleteTagResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTagResourcesResponse
		var err error
		defer close(result)
		response, err = client.DeleteTagResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTagResourcesRequest is the request struct for api DeleteTagResources
type DeleteTagResourcesRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	All             requests.Boolean `position:"Query" name:"All"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	TagKey          *[]string        `position:"Query" name:"TagKey"  type:"Repeated"`
	ResourceIds     *[]string        `position:"Query" name:"ResourceIds"  type:"Repeated"`
}

// DeleteTagResourcesResponse is the response struct for api DeleteTagResources
type DeleteTagResourcesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTagResourcesRequest creates a request to invoke DeleteTagResources API
func CreateDeleteTagResourcesRequest() (request *DeleteTagResourcesRequest) {
	request = &DeleteTagResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DeleteTagResources", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTagResourcesResponse creates a response to parse from DeleteTagResources response
func CreateDeleteTagResourcesResponse() (response *DeleteTagResourcesResponse) {
	response = &DeleteTagResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
