package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutDcdnKvWithHighCapacity invokes the dcdn.PutDcdnKvWithHighCapacity API synchronously
func (client *Client) PutDcdnKvWithHighCapacity(request *PutDcdnKvWithHighCapacityRequest) (response *PutDcdnKvWithHighCapacityResponse, err error) {
	response = CreatePutDcdnKvWithHighCapacityResponse()
	err = client.DoAction(request, response)
	return
}

// PutDcdnKvWithHighCapacityWithChan invokes the dcdn.PutDcdnKvWithHighCapacity API asynchronously
func (client *Client) PutDcdnKvWithHighCapacityWithChan(request *PutDcdnKvWithHighCapacityRequest) (<-chan *PutDcdnKvWithHighCapacityResponse, <-chan error) {
	responseChan := make(chan *PutDcdnKvWithHighCapacityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutDcdnKvWithHighCapacity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutDcdnKvWithHighCapacityWithCallback invokes the dcdn.PutDcdnKvWithHighCapacity API asynchronously
func (client *Client) PutDcdnKvWithHighCapacityWithCallback(request *PutDcdnKvWithHighCapacityRequest, callback func(response *PutDcdnKvWithHighCapacityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutDcdnKvWithHighCapacityResponse
		var err error
		defer close(result)
		response, err = client.PutDcdnKvWithHighCapacity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutDcdnKvWithHighCapacityRequest is the request struct for api PutDcdnKvWithHighCapacity
type PutDcdnKvWithHighCapacityRequest struct {
	*requests.RpcRequest
	Namespace string `position:"Query" name:"Namespace"`
	Key       string `position:"Query" name:"Key"`
	Url       string `position:"Query" name:"Url"`
}

// PutDcdnKvWithHighCapacityResponse is the response struct for api PutDcdnKvWithHighCapacity
type PutDcdnKvWithHighCapacityResponse struct {
	*responses.BaseResponse
	Length    int    `json:"Length" xml:"Length"`
	Value     string `json:"Value" xml:"Value"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutDcdnKvWithHighCapacityRequest creates a request to invoke PutDcdnKvWithHighCapacity API
func CreatePutDcdnKvWithHighCapacityRequest() (request *PutDcdnKvWithHighCapacityRequest) {
	request = &PutDcdnKvWithHighCapacityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "PutDcdnKvWithHighCapacity", "", "")
	request.Method = requests.POST
	return
}

// CreatePutDcdnKvWithHighCapacityResponse creates a response to parse from PutDcdnKvWithHighCapacity response
func CreatePutDcdnKvWithHighCapacityResponse() (response *PutDcdnKvWithHighCapacityResponse) {
	response = &PutDcdnKvWithHighCapacityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
