package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TopTenErrorTimesInstance invokes the dataworks_public.TopTenErrorTimesInstance API synchronously
func (client *Client) TopTenErrorTimesInstance(request *TopTenErrorTimesInstanceRequest) (response *TopTenErrorTimesInstanceResponse, err error) {
	response = CreateTopTenErrorTimesInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// TopTenErrorTimesInstanceWithChan invokes the dataworks_public.TopTenErrorTimesInstance API asynchronously
func (client *Client) TopTenErrorTimesInstanceWithChan(request *TopTenErrorTimesInstanceRequest) (<-chan *TopTenErrorTimesInstanceResponse, <-chan error) {
	responseChan := make(chan *TopTenErrorTimesInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TopTenErrorTimesInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TopTenErrorTimesInstanceWithCallback invokes the dataworks_public.TopTenErrorTimesInstance API asynchronously
func (client *Client) TopTenErrorTimesInstanceWithCallback(request *TopTenErrorTimesInstanceRequest, callback func(response *TopTenErrorTimesInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TopTenErrorTimesInstanceResponse
		var err error
		defer close(result)
		response, err = client.TopTenErrorTimesInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TopTenErrorTimesInstanceRequest is the request struct for api TopTenErrorTimesInstance
type TopTenErrorTimesInstanceRequest struct {
	*requests.RpcRequest
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// TopTenErrorTimesInstanceResponse is the response struct for api TopTenErrorTimesInstance
type TopTenErrorTimesInstanceResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	InstanceErrorRank InstanceErrorRank `json:"InstanceErrorRank" xml:"InstanceErrorRank"`
}

// CreateTopTenErrorTimesInstanceRequest creates a request to invoke TopTenErrorTimesInstance API
func CreateTopTenErrorTimesInstanceRequest() (request *TopTenErrorTimesInstanceRequest) {
	request = &TopTenErrorTimesInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "TopTenErrorTimesInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateTopTenErrorTimesInstanceResponse creates a response to parse from TopTenErrorTimesInstance response
func CreateTopTenErrorTimesInstanceResponse() (response *TopTenErrorTimesInstanceResponse) {
	response = &TopTenErrorTimesInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
