package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSensitiveData invokes the dataworks_public.GetSensitiveData API synchronously
func (client *Client) GetSensitiveData(request *GetSensitiveDataRequest) (response *GetSensitiveDataResponse, err error) {
	response = CreateGetSensitiveDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetSensitiveDataWithChan invokes the dataworks_public.GetSensitiveData API asynchronously
func (client *Client) GetSensitiveDataWithChan(request *GetSensitiveDataRequest) (<-chan *GetSensitiveDataResponse, <-chan error) {
	responseChan := make(chan *GetSensitiveDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSensitiveData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSensitiveDataWithCallback invokes the dataworks_public.GetSensitiveData API asynchronously
func (client *Client) GetSensitiveDataWithCallback(request *GetSensitiveDataRequest, callback func(response *GetSensitiveDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSensitiveDataResponse
		var err error
		defer close(result)
		response, err = client.GetSensitiveData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSensitiveDataRequest is the request struct for api GetSensitiveData
type GetSensitiveDataRequest struct {
	*requests.RpcRequest
	PageNo   requests.Integer `position:"Query" name:"PageNo"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Name     string           `position:"Query" name:"Name"`
}

// GetSensitiveDataResponse is the response struct for api GetSensitiveData
type GetSensitiveDataResponse struct {
	*responses.BaseResponse
	SensitiveData map[string]interface{} `json:"SensitiveData" xml:"SensitiveData"`
	RequestId     string                 `json:"RequestId" xml:"RequestId"`
}

// CreateGetSensitiveDataRequest creates a request to invoke GetSensitiveData API
func CreateGetSensitiveDataRequest() (request *GetSensitiveDataRequest) {
	request = &GetSensitiveDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetSensitiveData", "", "")
	request.Method = requests.GET
	return
}

// CreateGetSensitiveDataResponse creates a response to parse from GetSensitiveData response
func CreateGetSensitiveDataResponse() (response *GetSensitiveDataResponse) {
	response = &GetSensitiveDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
