package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaTableProducingTasks invokes the dataworks_public.GetMetaTableProducingTasks API synchronously
func (client *Client) GetMetaTableProducingTasks(request *GetMetaTableProducingTasksRequest) (response *GetMetaTableProducingTasksResponse, err error) {
	response = CreateGetMetaTableProducingTasksResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaTableProducingTasksWithChan invokes the dataworks_public.GetMetaTableProducingTasks API asynchronously
func (client *Client) GetMetaTableProducingTasksWithChan(request *GetMetaTableProducingTasksRequest) (<-chan *GetMetaTableProducingTasksResponse, <-chan error) {
	responseChan := make(chan *GetMetaTableProducingTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaTableProducingTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaTableProducingTasksWithCallback invokes the dataworks_public.GetMetaTableProducingTasks API asynchronously
func (client *Client) GetMetaTableProducingTasksWithCallback(request *GetMetaTableProducingTasksRequest, callback func(response *GetMetaTableProducingTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaTableProducingTasksResponse
		var err error
		defer close(result)
		response, err = client.GetMetaTableProducingTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaTableProducingTasksRequest is the request struct for api GetMetaTableProducingTasks
type GetMetaTableProducingTasksRequest struct {
	*requests.RpcRequest
	DataSourceType string `position:"Query" name:"DataSourceType"`
	SchemaName     string `position:"Query" name:"SchemaName"`
	ClusterId      string `position:"Query" name:"ClusterId"`
	DbName         string `position:"Query" name:"DbName"`
	TableGuid      string `position:"Query" name:"TableGuid"`
	TableName      string `position:"Query" name:"TableName"`
}

// GetMetaTableProducingTasksResponse is the response struct for api GetMetaTableProducingTasks
type GetMetaTableProducingTasksResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool       `json:"Success" xml:"Success"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateGetMetaTableProducingTasksRequest creates a request to invoke GetMetaTableProducingTasks API
func CreateGetMetaTableProducingTasksRequest() (request *GetMetaTableProducingTasksRequest) {
	request = &GetMetaTableProducingTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaTableProducingTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMetaTableProducingTasksResponse creates a response to parse from GetMetaTableProducingTasks response
func CreateGetMetaTableProducingTasksResponse() (response *GetMetaTableProducingTasksResponse) {
	response = &GetMetaTableProducingTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
