package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaDBTableList invokes the dataworks_public.GetMetaDBTableList API synchronously
func (client *Client) GetMetaDBTableList(request *GetMetaDBTableListRequest) (response *GetMetaDBTableListResponse, err error) {
	response = CreateGetMetaDBTableListResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaDBTableListWithChan invokes the dataworks_public.GetMetaDBTableList API asynchronously
func (client *Client) GetMetaDBTableListWithChan(request *GetMetaDBTableListRequest) (<-chan *GetMetaDBTableListResponse, <-chan error) {
	responseChan := make(chan *GetMetaDBTableListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaDBTableList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaDBTableListWithCallback invokes the dataworks_public.GetMetaDBTableList API asynchronously
func (client *Client) GetMetaDBTableListWithCallback(request *GetMetaDBTableListRequest, callback func(response *GetMetaDBTableListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaDBTableListResponse
		var err error
		defer close(result)
		response, err = client.GetMetaDBTableList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaDBTableListRequest is the request struct for api GetMetaDBTableList
type GetMetaDBTableListRequest struct {
	*requests.RpcRequest
	DataSourceType string           `position:"Query" name:"DataSourceType"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	DatabaseName   string           `position:"Query" name:"DatabaseName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AppGuid        string           `position:"Query" name:"AppGuid"`
}

// GetMetaDBTableListResponse is the response struct for api GetMetaDBTableList
type GetMetaDBTableListResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      DataInGetMetaDBTableList `json:"Data" xml:"Data"`
}

// CreateGetMetaDBTableListRequest creates a request to invoke GetMetaDBTableList API
func CreateGetMetaDBTableListRequest() (request *GetMetaDBTableListRequest) {
	request = &GetMetaDBTableListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaDBTableList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMetaDBTableListResponse creates a response to parse from GetMetaDBTableList response
func CreateGetMetaDBTableListResponse() (response *GetMetaDBTableListResponse) {
	response = &GetMetaDBTableListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
