package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceStatusCount invokes the dataworks_public.GetInstanceStatusCount API synchronously
func (client *Client) GetInstanceStatusCount(request *GetInstanceStatusCountRequest) (response *GetInstanceStatusCountResponse, err error) {
	response = CreateGetInstanceStatusCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceStatusCountWithChan invokes the dataworks_public.GetInstanceStatusCount API asynchronously
func (client *Client) GetInstanceStatusCountWithChan(request *GetInstanceStatusCountRequest) (<-chan *GetInstanceStatusCountResponse, <-chan error) {
	responseChan := make(chan *GetInstanceStatusCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceStatusCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceStatusCountWithCallback invokes the dataworks_public.GetInstanceStatusCount API asynchronously
func (client *Client) GetInstanceStatusCountWithCallback(request *GetInstanceStatusCountRequest, callback func(response *GetInstanceStatusCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceStatusCountResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceStatusCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceStatusCountRequest is the request struct for api GetInstanceStatusCount
type GetInstanceStatusCountRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	BizDate    string           `position:"Body" name:"BizDate"`
	ProjectId  requests.Integer `position:"Body" name:"ProjectId"`
}

// GetInstanceStatusCountResponse is the response struct for api GetInstanceStatusCount
type GetInstanceStatusCountResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	StatusCount StatusCount `json:"StatusCount" xml:"StatusCount"`
}

// CreateGetInstanceStatusCountRequest creates a request to invoke GetInstanceStatusCount API
func CreateGetInstanceStatusCountRequest() (request *GetInstanceStatusCountRequest) {
	request = &GetInstanceStatusCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetInstanceStatusCount", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstanceStatusCountResponse creates a response to parse from GetInstanceStatusCount response
func CreateGetInstanceStatusCountResponse() (response *GetInstanceStatusCountResponse) {
	response = &GetInstanceStatusCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
