package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMetaCollectionEntity invokes the dataworks_public.DeleteMetaCollectionEntity API synchronously
func (client *Client) DeleteMetaCollectionEntity(request *DeleteMetaCollectionEntityRequest) (response *DeleteMetaCollectionEntityResponse, err error) {
	response = CreateDeleteMetaCollectionEntityResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMetaCollectionEntityWithChan invokes the dataworks_public.DeleteMetaCollectionEntity API asynchronously
func (client *Client) DeleteMetaCollectionEntityWithChan(request *DeleteMetaCollectionEntityRequest) (<-chan *DeleteMetaCollectionEntityResponse, <-chan error) {
	responseChan := make(chan *DeleteMetaCollectionEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMetaCollectionEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMetaCollectionEntityWithCallback invokes the dataworks_public.DeleteMetaCollectionEntity API asynchronously
func (client *Client) DeleteMetaCollectionEntityWithCallback(request *DeleteMetaCollectionEntityRequest, callback func(response *DeleteMetaCollectionEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMetaCollectionEntityResponse
		var err error
		defer close(result)
		response, err = client.DeleteMetaCollectionEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMetaCollectionEntityRequest is the request struct for api DeleteMetaCollectionEntity
type DeleteMetaCollectionEntityRequest struct {
	*requests.RpcRequest
	EntityQualifiedName     string `position:"Query" name:"EntityQualifiedName"`
	CollectionQualifiedName string `position:"Query" name:"CollectionQualifiedName"`
}

// DeleteMetaCollectionEntityResponse is the response struct for api DeleteMetaCollectionEntity
type DeleteMetaCollectionEntityResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Status         bool   `json:"Status" xml:"Status"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeleteMetaCollectionEntityRequest creates a request to invoke DeleteMetaCollectionEntity API
func CreateDeleteMetaCollectionEntityRequest() (request *DeleteMetaCollectionEntityRequest) {
	request = &DeleteMetaCollectionEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteMetaCollectionEntity", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMetaCollectionEntityResponse creates a response to parse from DeleteMetaCollectionEntity response
func CreateDeleteMetaCollectionEntityResponse() (response *DeleteMetaCollectionEntityResponse) {
	response = &DeleteMetaCollectionEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
