package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBaseline invokes the dataworks_public.CreateBaseline API synchronously
func (client *Client) CreateBaseline(request *CreateBaselineRequest) (response *CreateBaselineResponse, err error) {
	response = CreateCreateBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBaselineWithChan invokes the dataworks_public.CreateBaseline API asynchronously
func (client *Client) CreateBaselineWithChan(request *CreateBaselineRequest) (<-chan *CreateBaselineResponse, <-chan error) {
	responseChan := make(chan *CreateBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBaselineWithCallback invokes the dataworks_public.CreateBaseline API asynchronously
func (client *Client) CreateBaselineWithCallback(request *CreateBaselineRequest, callback func(response *CreateBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBaselineResponse
		var err error
		defer close(result)
		response, err = client.CreateBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBaselineRequest is the request struct for api CreateBaseline
type CreateBaselineRequest struct {
	*requests.RpcRequest
	Owner                string                            `position:"Body" name:"Owner"`
	AlertMarginThreshold requests.Integer                  `position:"Body" name:"AlertMarginThreshold"`
	OvertimeSettings     *[]CreateBaselineOvertimeSettings `position:"Body" name:"OvertimeSettings"  type:"Repeated"`
	Priority             requests.Integer                  `position:"Body" name:"Priority"`
	BaselineType         string                            `position:"Body" name:"BaselineType"`
	BaselineName         string                            `position:"Body" name:"BaselineName"`
	ProjectId            requests.Integer                  `position:"Body" name:"ProjectId"`
	NodeIds              string                            `position:"Body" name:"NodeIds"`
}

// CreateBaselineOvertimeSettings is a repeated param struct in CreateBaselineRequest
type CreateBaselineOvertimeSettings struct {
	Time  string `name:"Time"`
	Cycle string `name:"Cycle"`
}

// CreateBaselineResponse is the response struct for api CreateBaseline
type CreateBaselineResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           int64  `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateBaselineRequest creates a request to invoke CreateBaseline API
func CreateCreateBaselineRequest() (request *CreateBaselineRequest) {
	request = &CreateBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateBaseline", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateBaselineResponse creates a response to parse from CreateBaseline response
func CreateCreateBaselineResponse() (response *CreateBaselineResponse) {
	response = &CreateBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
