package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRequestDiagnosisResult invokes the das.GetRequestDiagnosisResult API synchronously
func (client *Client) GetRequestDiagnosisResult(request *GetRequestDiagnosisResultRequest) (response *GetRequestDiagnosisResultResponse, err error) {
	response = CreateGetRequestDiagnosisResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetRequestDiagnosisResultWithChan invokes the das.GetRequestDiagnosisResult API asynchronously
func (client *Client) GetRequestDiagnosisResultWithChan(request *GetRequestDiagnosisResultRequest) (<-chan *GetRequestDiagnosisResultResponse, <-chan error) {
	responseChan := make(chan *GetRequestDiagnosisResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRequestDiagnosisResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRequestDiagnosisResultWithCallback invokes the das.GetRequestDiagnosisResult API asynchronously
func (client *Client) GetRequestDiagnosisResultWithCallback(request *GetRequestDiagnosisResultRequest, callback func(response *GetRequestDiagnosisResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRequestDiagnosisResultResponse
		var err error
		defer close(result)
		response, err = client.GetRequestDiagnosisResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRequestDiagnosisResultRequest is the request struct for api GetRequestDiagnosisResult
type GetRequestDiagnosisResultRequest struct {
	*requests.RpcRequest
	SqlId      string `position:"Query" name:"SqlId"`
	MessageId  string `position:"Query" name:"MessageId"`
	Source     string `position:"Query" name:"Source"`
	InstanceId string `position:"Query" name:"InstanceId"`
	NodeId     string `position:"Query" name:"NodeId"`
}

// GetRequestDiagnosisResultResponse is the response struct for api GetRequestDiagnosisResult
type GetRequestDiagnosisResultResponse struct {
	*responses.BaseResponse
	Message   string                          `json:"Message" xml:"Message"`
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Code      string                          `json:"Code" xml:"Code"`
	Success   string                          `json:"Success" xml:"Success"`
	Data      DataInGetRequestDiagnosisResult `json:"Data" xml:"Data"`
}

// CreateGetRequestDiagnosisResultRequest creates a request to invoke GetRequestDiagnosisResult API
func CreateGetRequestDiagnosisResultRequest() (request *GetRequestDiagnosisResultRequest) {
	request = &GetRequestDiagnosisResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetRequestDiagnosisResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetRequestDiagnosisResultResponse creates a response to parse from GetRequestDiagnosisResult response
func CreateGetRequestDiagnosisResultResponse() (response *GetRequestDiagnosisResultResponse) {
	response = &GetRequestDiagnosisResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
