package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPartitionsHeatmap invokes the das.GetPartitionsHeatmap API synchronously
func (client *Client) GetPartitionsHeatmap(request *GetPartitionsHeatmapRequest) (response *GetPartitionsHeatmapResponse, err error) {
	response = CreateGetPartitionsHeatmapResponse()
	err = client.DoAction(request, response)
	return
}

// GetPartitionsHeatmapWithChan invokes the das.GetPartitionsHeatmap API asynchronously
func (client *Client) GetPartitionsHeatmapWithChan(request *GetPartitionsHeatmapRequest) (<-chan *GetPartitionsHeatmapResponse, <-chan error) {
	responseChan := make(chan *GetPartitionsHeatmapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPartitionsHeatmap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPartitionsHeatmapWithCallback invokes the das.GetPartitionsHeatmap API asynchronously
func (client *Client) GetPartitionsHeatmapWithCallback(request *GetPartitionsHeatmapRequest, callback func(response *GetPartitionsHeatmapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPartitionsHeatmapResponse
		var err error
		defer close(result)
		response, err = client.GetPartitionsHeatmap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPartitionsHeatmapRequest is the request struct for api GetPartitionsHeatmap
type GetPartitionsHeatmapRequest struct {
	*requests.RpcRequest
	TimeRange      string `position:"Query" name:"TimeRange"`
	Type           string `position:"Query" name:"Type"`
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// GetPartitionsHeatmapResponse is the response struct for api GetPartitionsHeatmap
type GetPartitionsHeatmapResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateGetPartitionsHeatmapRequest creates a request to invoke GetPartitionsHeatmap API
func CreateGetPartitionsHeatmapRequest() (request *GetPartitionsHeatmapRequest) {
	request = &GetPartitionsHeatmapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetPartitionsHeatmap", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPartitionsHeatmapResponse creates a response to parse from GetPartitionsHeatmap response
func CreateGetPartitionsHeatmapResponse() (response *GetPartitionsHeatmapResponse) {
	response = &GetPartitionsHeatmapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
