package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportUserDevices invokes the csas.ExportUserDevices API synchronously
func (client *Client) ExportUserDevices(request *ExportUserDevicesRequest) (response *ExportUserDevicesResponse, err error) {
	response = CreateExportUserDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// ExportUserDevicesWithChan invokes the csas.ExportUserDevices API asynchronously
func (client *Client) ExportUserDevicesWithChan(request *ExportUserDevicesRequest) (<-chan *ExportUserDevicesResponse, <-chan error) {
	responseChan := make(chan *ExportUserDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportUserDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportUserDevicesWithCallback invokes the csas.ExportUserDevices API asynchronously
func (client *Client) ExportUserDevicesWithCallback(request *ExportUserDevicesRequest, callback func(response *ExportUserDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportUserDevicesResponse
		var err error
		defer close(result)
		response, err = client.ExportUserDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportUserDevicesRequest is the request struct for api ExportUserDevices
type ExportUserDevicesRequest struct {
	*requests.RpcRequest
	Mac            string           `position:"Body" name:"Mac"`
	DeviceTypes    *[]string        `position:"Body" name:"DeviceTypes"  type:"Repeated"`
	Hostname       string           `position:"Body" name:"Hostname"`
	AppStatuses    *[]string        `position:"Body" name:"AppStatuses"  type:"Repeated"`
	DlpStatuses    *[]string        `position:"Body" name:"DlpStatuses"  type:"Repeated"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	SaseUserId     string           `position:"Body" name:"SaseUserId"`
	NacStatuses    *[]string        `position:"Body" name:"NacStatuses"  type:"Repeated"`
	Department     string           `position:"Body" name:"Department"`
	IaStatuses     *[]string        `position:"Body" name:"IaStatuses"  type:"Repeated"`
	DeviceBelong   string           `position:"Body" name:"DeviceBelong"`
	SharingStatus  requests.Boolean `position:"Body" name:"SharingStatus"`
	DeviceTags     *[]string        `position:"Body" name:"DeviceTags"  type:"Repeated"`
	DeviceStatuses *[]string        `position:"Body" name:"DeviceStatuses"  type:"Repeated"`
	PaStatuses     *[]string        `position:"Body" name:"PaStatuses"  type:"Repeated"`
	Username       string           `position:"Body" name:"Username"`
}

// ExportUserDevicesResponse is the response struct for api ExportUserDevices
type ExportUserDevicesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	SignedUrl string `json:"SignedUrl" xml:"SignedUrl"`
}

// CreateExportUserDevicesRequest creates a request to invoke ExportUserDevices API
func CreateExportUserDevicesRequest() (request *ExportUserDevicesRequest) {
	request = &ExportUserDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ExportUserDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateExportUserDevicesResponse creates a response to parse from ExportUserDevices response
func CreateExportUserDevicesResponse() (response *ExportUserDevicesResponse) {
	response = &ExportUserDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
