package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWmEmbedTask invokes the csas.CreateWmEmbedTask API synchronously
func (client *Client) CreateWmEmbedTask(request *CreateWmEmbedTaskRequest) (response *CreateWmEmbedTaskResponse, err error) {
	response = CreateCreateWmEmbedTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWmEmbedTaskWithChan invokes the csas.CreateWmEmbedTask API asynchronously
func (client *Client) CreateWmEmbedTaskWithChan(request *CreateWmEmbedTaskRequest) (<-chan *CreateWmEmbedTaskResponse, <-chan error) {
	responseChan := make(chan *CreateWmEmbedTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWmEmbedTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWmEmbedTaskWithCallback invokes the csas.CreateWmEmbedTask API asynchronously
func (client *Client) CreateWmEmbedTaskWithCallback(request *CreateWmEmbedTaskRequest, callback func(response *CreateWmEmbedTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWmEmbedTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateWmEmbedTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWmEmbedTaskRequest is the request struct for api CreateWmEmbedTask
type CreateWmEmbedTaskRequest struct {
	*requests.RpcRequest
	VideoIsLong           requests.Boolean                 `position:"Body" name:"VideoIsLong"`
	ApiType               string                           `position:"Body" name:"ApiType"`
	SourceIp              string                           `position:"Query" name:"SourceIp"`
	ImageEmbedLevel       requests.Integer                 `position:"Body" name:"ImageEmbedLevel"`
	WmType                string                           `position:"Body" name:"WmType"`
	DocumentControl       CreateWmEmbedTaskDocumentControl `position:"Body" name:"DocumentControl"  type:"Struct"`
	ImageEmbedJpegQuality requests.Integer                 `position:"Body" name:"ImageEmbedJpegQuality"`
	WatermarkInfoUint     requests.Integer                 `position:"Body" name:"WatermarkInfoUint"`
	WmInfoUint            string                           `position:"Body" name:"WmInfoUint"`
	CsvControl            CreateWmEmbedTaskCsvControl      `position:"Query" name:"CsvControl"  type:"Struct"`
	Filename              string                           `position:"Body" name:"Filename"`
	WmInfoSize            requests.Integer                 `position:"Body" name:"WmInfoSize"`
	WmInfoBytesB64        string                           `position:"Body" name:"WmInfoBytesB64"`
	FileUrl               string                           `position:"Body" name:"FileUrl"`
	VideoBitrate          string                           `position:"Body" name:"VideoBitrate"`
}

// CreateWmEmbedTaskDocumentControl is a repeated param struct in CreateWmEmbedTaskRequest
type CreateWmEmbedTaskDocumentControl struct {
	InvisibleAntiAllCopy  string                                            `name:"InvisibleAntiAllCopy"`
	BackgroundControl     CreateWmEmbedTaskDocumentControlBackgroundControl `name:"BackgroundControl" type:"Struct"`
	InvisibleAntiTextCopy string                                            `name:"InvisibleAntiTextCopy"`
}

// CreateWmEmbedTaskCsvControl is a repeated param struct in CreateWmEmbedTaskRequest
type CreateWmEmbedTaskCsvControl struct {
	Method         string `name:"Method"`
	EmbedColumn    string `name:"EmbedColumn"`
	EmbedPrecision string `name:"EmbedPrecision"`
}

// CreateWmEmbedTaskDocumentControlBackgroundControl is a repeated param struct in CreateWmEmbedTaskRequest
type CreateWmEmbedTaskDocumentControlBackgroundControl struct {
	BgAddInvisible     string                                                              `name:"BgAddInvisible"`
	BgVisibleControl   CreateWmEmbedTaskDocumentControlBackgroundControlBgVisibleControl   `name:"BgVisibleControl" type:"Struct"`
	BgInvisibleControl CreateWmEmbedTaskDocumentControlBackgroundControlBgInvisibleControl `name:"BgInvisibleControl" type:"Struct"`
	BgAddVisible       string                                                              `name:"BgAddVisible"`
}

// CreateWmEmbedTaskDocumentControlBackgroundControlBgVisibleControl is a repeated param struct in CreateWmEmbedTaskRequest
type CreateWmEmbedTaskDocumentControlBackgroundControlBgVisibleControl struct {
	Mode             string `name:"Mode"`
	PosX             string `name:"PosX"`
	PosY             string `name:"PosY"`
	VerticalNumber   string `name:"VerticalNumber"`
	HorizontalNumber string `name:"HorizontalNumber"`
	VisibleText      string `name:"VisibleText"`
	FontSize         string `name:"FontSize"`
	FontColor        string `name:"FontColor"`
	Angle            string `name:"Angle"`
	HorizonNumber    string `name:"HorizonNumber"`
	Opacity          string `name:"Opacity"`
	FontTransparent  string `name:"FontTransparent"`
}

// CreateWmEmbedTaskDocumentControlBackgroundControlBgInvisibleControl is a repeated param struct in CreateWmEmbedTaskRequest
type CreateWmEmbedTaskDocumentControlBackgroundControlBgInvisibleControl struct {
	InvisibleTransparent string `name:"InvisibleTransparent"`
	Opacity              string `name:"Opacity"`
}

// CreateWmEmbedTaskResponse is the response struct for api CreateWmEmbedTask
type CreateWmEmbedTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateWmEmbedTaskRequest creates a request to invoke CreateWmEmbedTask API
func CreateCreateWmEmbedTaskRequest() (request *CreateWmEmbedTaskRequest) {
	request = &CreateWmEmbedTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "CreateWmEmbedTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateWmEmbedTaskResponse creates a response to parse from CreateWmEmbedTask response
func CreateCreateWmEmbedTaskResponse() (response *CreateWmEmbedTaskResponse) {
	response = &CreateWmEmbedTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
