package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateAggregateConfigRulesReport invokes the config.GenerateAggregateConfigRulesReport API synchronously
func (client *Client) GenerateAggregateConfigRulesReport(request *GenerateAggregateConfigRulesReportRequest) (response *GenerateAggregateConfigRulesReportResponse, err error) {
	response = CreateGenerateAggregateConfigRulesReportResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateAggregateConfigRulesReportWithChan invokes the config.GenerateAggregateConfigRulesReport API asynchronously
func (client *Client) GenerateAggregateConfigRulesReportWithChan(request *GenerateAggregateConfigRulesReportRequest) (<-chan *GenerateAggregateConfigRulesReportResponse, <-chan error) {
	responseChan := make(chan *GenerateAggregateConfigRulesReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateAggregateConfigRulesReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateAggregateConfigRulesReportWithCallback invokes the config.GenerateAggregateConfigRulesReport API asynchronously
func (client *Client) GenerateAggregateConfigRulesReportWithCallback(request *GenerateAggregateConfigRulesReportRequest, callback func(response *GenerateAggregateConfigRulesReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateAggregateConfigRulesReportResponse
		var err error
		defer close(result)
		response, err = client.GenerateAggregateConfigRulesReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateAggregateConfigRulesReportRequest is the request struct for api GenerateAggregateConfigRulesReport
type GenerateAggregateConfigRulesReportRequest struct {
	*requests.RpcRequest
	ClientToken   string `position:"Body" name:"ClientToken"`
	ConfigRuleIds string `position:"Body" name:"ConfigRuleIds"`
	AggregatorId  string `position:"Body" name:"AggregatorId"`
}

// GenerateAggregateConfigRulesReportResponse is the response struct for api GenerateAggregateConfigRulesReport
type GenerateAggregateConfigRulesReportResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	AggregatorId string `json:"AggregatorId" xml:"AggregatorId"`
	ReportId     string `json:"ReportId" xml:"ReportId"`
}

// CreateGenerateAggregateConfigRulesReportRequest creates a request to invoke GenerateAggregateConfigRulesReport API
func CreateGenerateAggregateConfigRulesReportRequest() (request *GenerateAggregateConfigRulesReportRequest) {
	request = &GenerateAggregateConfigRulesReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GenerateAggregateConfigRulesReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateAggregateConfigRulesReportResponse creates a response to parse from GenerateAggregateConfigRulesReport response
func CreateGenerateAggregateConfigRulesReportResponse() (response *GenerateAggregateConfigRulesReportResponse) {
	response = &GenerateAggregateConfigRulesReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
