package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachConfigRuleToCompliancePack invokes the config.AttachConfigRuleToCompliancePack API synchronously
func (client *Client) AttachConfigRuleToCompliancePack(request *AttachConfigRuleToCompliancePackRequest) (response *AttachConfigRuleToCompliancePackResponse, err error) {
	response = CreateAttachConfigRuleToCompliancePackResponse()
	err = client.DoAction(request, response)
	return
}

// AttachConfigRuleToCompliancePackWithChan invokes the config.AttachConfigRuleToCompliancePack API asynchronously
func (client *Client) AttachConfigRuleToCompliancePackWithChan(request *AttachConfigRuleToCompliancePackRequest) (<-chan *AttachConfigRuleToCompliancePackResponse, <-chan error) {
	responseChan := make(chan *AttachConfigRuleToCompliancePackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachConfigRuleToCompliancePack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachConfigRuleToCompliancePackWithCallback invokes the config.AttachConfigRuleToCompliancePack API asynchronously
func (client *Client) AttachConfigRuleToCompliancePackWithCallback(request *AttachConfigRuleToCompliancePackRequest, callback func(response *AttachConfigRuleToCompliancePackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachConfigRuleToCompliancePackResponse
		var err error
		defer close(result)
		response, err = client.AttachConfigRuleToCompliancePack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachConfigRuleToCompliancePackRequest is the request struct for api AttachConfigRuleToCompliancePack
type AttachConfigRuleToCompliancePackRequest struct {
	*requests.RpcRequest
	ConfigRuleIds    string `position:"Query" name:"ConfigRuleIds"`
	CompliancePackId string `position:"Query" name:"CompliancePackId"`
}

// AttachConfigRuleToCompliancePackResponse is the response struct for api AttachConfigRuleToCompliancePack
type AttachConfigRuleToCompliancePackResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	OperateRuleResult OperateRuleResult `json:"OperateRuleResult" xml:"OperateRuleResult"`
}

// CreateAttachConfigRuleToCompliancePackRequest creates a request to invoke AttachConfigRuleToCompliancePack API
func CreateAttachConfigRuleToCompliancePackRequest() (request *AttachConfigRuleToCompliancePackRequest) {
	request = &AttachConfigRuleToCompliancePackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "AttachConfigRuleToCompliancePack", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachConfigRuleToCompliancePackResponse creates a response to parse from AttachConfigRuleToCompliancePack response
func CreateAttachConfigRuleToCompliancePackResponse() (response *AttachConfigRuleToCompliancePackResponse) {
	response = &AttachConfigRuleToCompliancePackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
