package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUploadCredentials invokes the computenestsupplier.GetUploadCredentials API synchronously
func (client *Client) GetUploadCredentials(request *GetUploadCredentialsRequest) (response *GetUploadCredentialsResponse, err error) {
	response = CreateGetUploadCredentialsResponse()
	err = client.DoAction(request, response)
	return
}

// GetUploadCredentialsWithChan invokes the computenestsupplier.GetUploadCredentials API asynchronously
func (client *Client) GetUploadCredentialsWithChan(request *GetUploadCredentialsRequest) (<-chan *GetUploadCredentialsResponse, <-chan error) {
	responseChan := make(chan *GetUploadCredentialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUploadCredentials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUploadCredentialsWithCallback invokes the computenestsupplier.GetUploadCredentials API asynchronously
func (client *Client) GetUploadCredentialsWithCallback(request *GetUploadCredentialsRequest, callback func(response *GetUploadCredentialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUploadCredentialsResponse
		var err error
		defer close(result)
		response, err = client.GetUploadCredentials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUploadCredentialsRequest is the request struct for api GetUploadCredentials
type GetUploadCredentialsRequest struct {
	*requests.RpcRequest
	FileName string `position:"Query" name:"FileName"`
}

// GetUploadCredentialsResponse is the response struct for api GetUploadCredentials
type GetUploadCredentialsResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetUploadCredentialsRequest creates a request to invoke GetUploadCredentials API
func CreateGetUploadCredentialsRequest() (request *GetUploadCredentialsRequest) {
	request = &GetUploadCredentialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "GetUploadCredentials", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUploadCredentialsResponse creates a response to parse from GetUploadCredentials response
func CreateGetUploadCredentialsResponse() (response *GetUploadCredentialsResponse) {
	response = &GetUploadCredentialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
