package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseIntentionForPartner invokes the companyreg.CloseIntentionForPartner API synchronously
func (client *Client) CloseIntentionForPartner(request *CloseIntentionForPartnerRequest) (response *CloseIntentionForPartnerResponse, err error) {
	response = CreateCloseIntentionForPartnerResponse()
	err = client.DoAction(request, response)
	return
}

// CloseIntentionForPartnerWithChan invokes the companyreg.CloseIntentionForPartner API asynchronously
func (client *Client) CloseIntentionForPartnerWithChan(request *CloseIntentionForPartnerRequest) (<-chan *CloseIntentionForPartnerResponse, <-chan error) {
	responseChan := make(chan *CloseIntentionForPartnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseIntentionForPartner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseIntentionForPartnerWithCallback invokes the companyreg.CloseIntentionForPartner API asynchronously
func (client *Client) CloseIntentionForPartnerWithCallback(request *CloseIntentionForPartnerRequest, callback func(response *CloseIntentionForPartnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseIntentionForPartnerResponse
		var err error
		defer close(result)
		response, err = client.CloseIntentionForPartner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseIntentionForPartnerRequest is the request struct for api CloseIntentionForPartner
type CloseIntentionForPartnerRequest struct {
	*requests.RpcRequest
	BizType        string `position:"Query" name:"BizType"`
	Note           string `position:"Query" name:"Note"`
	IntentionBizId string `position:"Query" name:"IntentionBizId"`
}

// CloseIntentionForPartnerResponse is the response struct for api CloseIntentionForPartner
type CloseIntentionForPartnerResponse struct {
	*responses.BaseResponse
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateCloseIntentionForPartnerRequest creates a request to invoke CloseIntentionForPartner API
func CreateCloseIntentionForPartnerRequest() (request *CloseIntentionForPartnerRequest) {
	request = &CloseIntentionForPartnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "CloseIntentionForPartner", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseIntentionForPartnerResponse creates a response to parse from CloseIntentionForPartner response
func CreateCloseIntentionForPartnerResponse() (response *CloseIntentionForPartnerResponse) {
	response = &CloseIntentionForPartnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
