package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCustomMetricList invokes the cms.DescribeCustomMetricList API synchronously
func (client *Client) DescribeCustomMetricList(request *DescribeCustomMetricListRequest) (response *DescribeCustomMetricListResponse, err error) {
	response = CreateDescribeCustomMetricListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCustomMetricListWithChan invokes the cms.DescribeCustomMetricList API asynchronously
func (client *Client) DescribeCustomMetricListWithChan(request *DescribeCustomMetricListRequest) (<-chan *DescribeCustomMetricListResponse, <-chan error) {
	responseChan := make(chan *DescribeCustomMetricListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCustomMetricList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCustomMetricListWithCallback invokes the cms.DescribeCustomMetricList API asynchronously
func (client *Client) DescribeCustomMetricListWithCallback(request *DescribeCustomMetricListRequest, callback func(response *DescribeCustomMetricListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCustomMetricListResponse
		var err error
		defer close(result)
		response, err = client.DescribeCustomMetricList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCustomMetricListRequest is the request struct for api DescribeCustomMetricList
type DescribeCustomMetricListRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	PageNumber string `position:"Query" name:"PageNumber"`
	PageSize   string `position:"Query" name:"PageSize"`
	MetricName string `position:"Query" name:"MetricName"`
	Dimension  string `position:"Query" name:"Dimension"`
	Md5        string `position:"Query" name:"Md5"`
}

// DescribeCustomMetricListResponse is the response struct for api DescribeCustomMetricList
type DescribeCustomMetricListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDescribeCustomMetricListRequest creates a request to invoke DescribeCustomMetricList API
func CreateDescribeCustomMetricListRequest() (request *DescribeCustomMetricListRequest) {
	request = &DescribeCustomMetricListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeCustomMetricList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCustomMetricListResponse creates a response to parse from DescribeCustomMetricList response
func CreateDescribeCustomMetricListResponse() (response *DescribeCustomMetricListResponse) {
	response = &DescribeCustomMetricListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
