package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindAp invokes the cloudwf.FindAp API synchronously
// api document: https://help.aliyun.com/api/cloudwf/findap.html
func (client *Client) FindAp(request *FindApRequest) (response *FindApResponse, err error) {
	response = CreateFindApResponse()
	err = client.DoAction(request, response)
	return
}

// FindApWithChan invokes the cloudwf.FindAp API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/findap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindApWithChan(request *FindApRequest) (<-chan *FindApResponse, <-chan error) {
	responseChan := make(chan *FindApResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindAp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindApWithCallback invokes the cloudwf.FindAp API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/findap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindApWithCallback(request *FindApRequest, callback func(response *FindApResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindApResponse
		var err error
		defer close(result)
		response, err = client.FindAp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindApRequest is the request struct for api FindAp
type FindApRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// FindApResponse is the response struct for api FindAp
type FindApResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateFindApRequest creates a request to invoke FindAp API
func CreateFindApRequest() (request *FindApRequest) {
	request = &FindApRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "FindAp", "cloudwf", "openAPI")
	return
}

// CreateFindApResponse creates a response to parse from FindAp response
func CreateFindApResponse() (response *FindApResponse) {
	response = &FindApResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
