package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVulnerabilityProtectedList invokes the cloudfw.DescribeVulnerabilityProtectedList API synchronously
func (client *Client) DescribeVulnerabilityProtectedList(request *DescribeVulnerabilityProtectedListRequest) (response *DescribeVulnerabilityProtectedListResponse, err error) {
	response = CreateDescribeVulnerabilityProtectedListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVulnerabilityProtectedListWithChan invokes the cloudfw.DescribeVulnerabilityProtectedList API asynchronously
func (client *Client) DescribeVulnerabilityProtectedListWithChan(request *DescribeVulnerabilityProtectedListRequest) (<-chan *DescribeVulnerabilityProtectedListResponse, <-chan error) {
	responseChan := make(chan *DescribeVulnerabilityProtectedListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVulnerabilityProtectedList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVulnerabilityProtectedListWithCallback invokes the cloudfw.DescribeVulnerabilityProtectedList API asynchronously
func (client *Client) DescribeVulnerabilityProtectedListWithCallback(request *DescribeVulnerabilityProtectedListRequest, callback func(response *DescribeVulnerabilityProtectedListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVulnerabilityProtectedListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVulnerabilityProtectedList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVulnerabilityProtectedListRequest is the request struct for api DescribeVulnerabilityProtectedList
type DescribeVulnerabilityProtectedListRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	VulnLevel    string           `position:"Query" name:"VulnLevel"`
	SortKey      string           `position:"Query" name:"SortKey"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	BuyVersion   requests.Integer `position:"Query" name:"BuyVersion"`
	PageSize     string           `position:"Query" name:"PageSize"`
	Lang         string           `position:"Query" name:"Lang"`
	Order        string           `position:"Query" name:"Order"`
	AttackType   string           `position:"Query" name:"AttackType"`
	VulnStatus   string           `position:"Query" name:"VulnStatus"`
	VulnType     string           `position:"Query" name:"VulnType"`
	EndTime      string           `position:"Query" name:"EndTime"`
	UserType     string           `position:"Query" name:"UserType"`
	CurrentPage  string           `position:"Query" name:"CurrentPage"`
	MemberUid    string           `position:"Query" name:"MemberUid"`
	VulnResource string           `position:"Query" name:"VulnResource"`
	VulnCveName  string           `position:"Query" name:"VulnCveName"`
}

// DescribeVulnerabilityProtectedListResponse is the response struct for api DescribeVulnerabilityProtectedList
type DescribeVulnerabilityProtectedListResponse struct {
	*responses.BaseResponse
	RequestId         string                                     `json:"RequestId" xml:"RequestId"`
	TotalCount        int                                        `json:"TotalCount" xml:"TotalCount"`
	ZeroResourceCount int                                        `json:"ZeroResourceCount" xml:"ZeroResourceCount"`
	VulnList          []DataInDescribeVulnerabilityProtectedList `json:"VulnList" xml:"VulnList"`
}

// CreateDescribeVulnerabilityProtectedListRequest creates a request to invoke DescribeVulnerabilityProtectedList API
func CreateDescribeVulnerabilityProtectedListRequest() (request *DescribeVulnerabilityProtectedListRequest) {
	request = &DescribeVulnerabilityProtectedListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeVulnerabilityProtectedList", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVulnerabilityProtectedListResponse creates a response to parse from DescribeVulnerabilityProtectedList response
func CreateDescribeVulnerabilityProtectedListResponse() (response *DescribeVulnerabilityProtectedListResponse) {
	response = &DescribeVulnerabilityProtectedListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
