package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePolicyAdvancedConfig invokes the cloudfw.DescribePolicyAdvancedConfig API synchronously
func (client *Client) DescribePolicyAdvancedConfig(request *DescribePolicyAdvancedConfigRequest) (response *DescribePolicyAdvancedConfigResponse, err error) {
	response = CreateDescribePolicyAdvancedConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePolicyAdvancedConfigWithChan invokes the cloudfw.DescribePolicyAdvancedConfig API asynchronously
func (client *Client) DescribePolicyAdvancedConfigWithChan(request *DescribePolicyAdvancedConfigRequest) (<-chan *DescribePolicyAdvancedConfigResponse, <-chan error) {
	responseChan := make(chan *DescribePolicyAdvancedConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePolicyAdvancedConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePolicyAdvancedConfigWithCallback invokes the cloudfw.DescribePolicyAdvancedConfig API asynchronously
func (client *Client) DescribePolicyAdvancedConfigWithCallback(request *DescribePolicyAdvancedConfigRequest, callback func(response *DescribePolicyAdvancedConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePolicyAdvancedConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribePolicyAdvancedConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePolicyAdvancedConfigRequest is the request struct for api DescribePolicyAdvancedConfig
type DescribePolicyAdvancedConfigRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribePolicyAdvancedConfigResponse is the response struct for api DescribePolicyAdvancedConfig
type DescribePolicyAdvancedConfigResponse struct {
	*responses.BaseResponse
	InternetSwitch string `json:"InternetSwitch" xml:"InternetSwitch"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribePolicyAdvancedConfigRequest creates a request to invoke DescribePolicyAdvancedConfig API
func CreateDescribePolicyAdvancedConfigRequest() (request *DescribePolicyAdvancedConfigRequest) {
	request = &DescribePolicyAdvancedConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribePolicyAdvancedConfig", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePolicyAdvancedConfigResponse creates a response to parse from DescribePolicyAdvancedConfig response
func CreateDescribePolicyAdvancedConfigResponse() (response *DescribePolicyAdvancedConfigResponse) {
	response = &DescribePolicyAdvancedConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
